/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.operators.base.OuterJoinOperatorBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.AbstractOuterJoinDriver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.hash.NonReusingBuildFirstHashJoinIterator;
import org.apache.flink.runtime.operators.hash.NonReusingBuildSecondHashJoinIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildFirstHashJoinIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildSecondHashJoinIterator;
import org.apache.flink.runtime.operators.sort.NonReusingMergeOuterJoinIterator;
import org.apache.flink.runtime.operators.sort.ReusingMergeOuterJoinIterator;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.util.MutableObjectIterator;

public class RightOuterJoinDriver<IT1, IT2, OT>
extends AbstractOuterJoinDriver<IT1, IT2, OT> {
    @Override
    protected JoinTaskIterator<IT1, IT2, OT> getReusingOuterJoinIterator(DriverStrategy driverStrategy, MutableObjectIterator<IT1> in1, MutableObjectIterator<IT2> in2, TypeSerializer<IT1> serializer1, TypeComparator<IT1> comparator1, TypeSerializer<IT2> serializer2, TypeComparator<IT2> comparator2, TypePairComparatorFactory<IT1, IT2> pairComparatorFactory, MemoryManager memoryManager, IOManager ioManager, double driverMemFraction) throws Exception {
        switch (driverStrategy) {
            case RIGHT_OUTER_MERGE: {
                int numPages = memoryManager.computeNumberOfPages(driverMemFraction);
                return new ReusingMergeOuterJoinIterator(OuterJoinOperatorBase.OuterJoinType.RIGHT, in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, numPages, this.taskContext.getContainingTask());
            }
            case RIGHT_HYBRIDHASH_BUILD_FIRST: {
                return new ReusingBuildFirstHashJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getContainingTask(), driverMemFraction, true, false, false);
            }
            case RIGHT_HYBRIDHASH_BUILD_SECOND: {
                return new ReusingBuildSecondHashJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getContainingTask(), driverMemFraction, false, true, false);
            }
        }
        throw new Exception("Unsupported driver strategy for right outer join driver: " + driverStrategy.name());
    }

    @Override
    protected JoinTaskIterator<IT1, IT2, OT> getNonReusingOuterJoinIterator(DriverStrategy driverStrategy, MutableObjectIterator<IT1> in1, MutableObjectIterator<IT2> in2, TypeSerializer<IT1> serializer1, TypeComparator<IT1> comparator1, TypeSerializer<IT2> serializer2, TypeComparator<IT2> comparator2, TypePairComparatorFactory<IT1, IT2> pairComparatorFactory, MemoryManager memoryManager, IOManager ioManager, double driverMemFraction) throws Exception {
        switch (driverStrategy) {
            case RIGHT_OUTER_MERGE: {
                int numPages = memoryManager.computeNumberOfPages(driverMemFraction);
                return new NonReusingMergeOuterJoinIterator(OuterJoinOperatorBase.OuterJoinType.RIGHT, in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, numPages, this.taskContext.getContainingTask());
            }
            case RIGHT_HYBRIDHASH_BUILD_FIRST: {
                return new NonReusingBuildFirstHashJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getContainingTask(), driverMemFraction, true, false, false);
            }
            case RIGHT_HYBRIDHASH_BUILD_SECOND: {
                return new NonReusingBuildSecondHashJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getContainingTask(), driverMemFraction, false, true, false);
            }
        }
        throw new Exception("Unsupported driver strategy for right outer join driver: " + driverStrategy.name());
    }
}

