/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc;

import java.sql.ClientInfoStatus;
import java.sql.DatabaseMetaData;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.gateway.rest.util.RowFormat;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.jdbc.BaseConnection;
import org.apache.flink.table.jdbc.DriverUri;
import org.apache.flink.table.jdbc.FlinkDatabaseMetaData;
import org.apache.flink.table.jdbc.FlinkStatement;
import org.apache.flink.table.jdbc.utils.DriverUtils;

@NotThreadSafe
public class FlinkConnection
extends BaseConnection {
    private final String url;
    private final Executor executor;
    private final List<Statement> statements;
    private boolean closed = false;

    public FlinkConnection(DriverUri driverUri) {
        this.url = driverUri.getURL();
        this.statements = new ArrayList<Statement>();
        this.executor = Executor.create(new DefaultContext(DriverUtils.fromProperties(driverUri.getProperties()), Collections.emptyList()), driverUri.getAddress(), UUID.randomUUID().toString(), RowFormat.JSON);
        driverUri.getCatalog().ifPresent(this::setSessionCatalog);
        driverUri.getDatabase().ifPresent(this::setSessionSchema);
    }

    @VisibleForTesting
    FlinkConnection(Executor executor) {
        this.url = null;
        this.statements = new ArrayList<Statement>();
        this.executor = executor;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.ensureOpen();
        FlinkStatement statement = new FlinkStatement(this);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @VisibleForTesting
    Executor getExecutor() {
        return this.executor;
    }

    private void ensureOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The current connection is closed.");
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        ArrayList<Statement> remainStatements = new ArrayList<Statement>(this.statements);
        for (Statement statement : remainStatements) {
            statement.close();
        }
        remainStatements.clear();
        this.statements.clear();
        try {
            this.executor.close();
        }
        catch (Exception e) {
            throw new SQLException("Close connection fail", e);
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return new FlinkDatabaseMetaData(this.url, this, this.createStatement());
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureOpen();
        try {
            this.setSessionCatalog(catalog);
        }
        catch (Exception e) {
            throw new SQLException(String.format("Set catalog[%s] fail", catalog), e);
        }
    }

    private void setSessionCatalog(String catalog) {
        this.executor.configureSession(String.format("USE CATALOG %s;", catalog));
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureOpen();
        Throwable throwable = null;
        try (StatementResult result = this.executor.executeStatement("SHOW CURRENT CATALOG;");){
            if (result.hasNext()) {
                String catalog = result.next().getString(0).toString();
                DriverUtils.checkArgument(!result.hasNext(), "There are more than one current catalog.");
                String string = catalog;
                return string;
            }
            try {
                throw new SQLException("No catalog");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException("Connection is closed", new HashMap<String, ClientInfoStatus>(), (Throwable)e);
        }
        this.executor.configureSession(String.format("SET '%s'='%s';", name, value));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        for (Object key : properties.keySet()) {
            this.setClientInfo(key.toString(), properties.getProperty(key.toString()));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureOpen();
        Map<String, String> configuration = this.executor.getSessionConfigMap();
        return configuration.get(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureOpen();
        Properties properties = new Properties();
        Map<String, String> configuration = this.executor.getSessionConfigMap();
        configuration.forEach(properties::setProperty);
        return properties;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureOpen();
        try {
            this.setSessionSchema(schema);
        }
        catch (Exception e) {
            throw new SQLException(String.format("Set schema[%s] fail", schema), e);
        }
    }

    private void setSessionSchema(String schema) {
        this.executor.configureSession(String.format("USE %s;", schema));
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureOpen();
        Throwable throwable = null;
        try (StatementResult result = this.executor.executeStatement("SHOW CURRENT DATABASE;");){
            if (result.hasNext()) {
                String schema = result.next().getString(0).toString();
                DriverUtils.checkArgument(!result.hasNext(), "There are more than one current database.");
                String string = schema;
                return string;
            }
            try {
                throw new SQLException("No database");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    void removeStatement(FlinkStatement statement) {
        this.statements.remove(statement);
    }
}

