/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.UnresolvedDataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDuplicator;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.types.utils.TypeInfoDataTypeConverter;

@Internal
final class DataTypeFactoryImpl
implements DataTypeFactory {
    private final LogicalTypeResolver resolver = new LogicalTypeResolver();
    private final ClassLoader classLoader;
    private final Supplier<SerializerConfig> serializerConfig;

    DataTypeFactoryImpl(ClassLoader classLoader, ReadableConfig config, @Nullable SerializerConfig serializerConfig) {
        this.classLoader = classLoader;
        this.serializerConfig = DataTypeFactoryImpl.createSerializerConfig(classLoader, config, serializerConfig);
    }

    @Override
    public DataType createDataType(AbstractDataType<?> abstractDataType) {
        if (abstractDataType instanceof DataType) {
            return (DataType)abstractDataType;
        }
        if (abstractDataType instanceof UnresolvedDataType) {
            return ((UnresolvedDataType)abstractDataType).toDataType(this);
        }
        throw new ValidationException("Unsupported abstract data type.");
    }

    @Override
    public DataType createDataType(String typeString) {
        return TypeConversions.fromLogicalToDataType(this.createLogicalType(typeString));
    }

    @Override
    public DataType createDataType(UnresolvedIdentifier identifier) {
        return TypeConversions.fromLogicalToDataType(this.createLogicalType(identifier));
    }

    @Override
    public <T> DataType createDataType(Class<T> clazz) {
        return DataTypeExtractor.extractFromType(this, clazz);
    }

    @Override
    public <T> DataType createDataType(TypeInformation<T> typeInfo) {
        return TypeInfoDataTypeConverter.toDataType(this, typeInfo);
    }

    @Override
    public <T> DataType createRawDataType(Class<T> clazz) {
        return DataTypes.RAW(clazz, new KryoSerializer<T>(clazz, this.serializerConfig.get()));
    }

    @Override
    public <T> DataType createRawDataType(TypeInformation<T> typeInfo) {
        return DataTypes.RAW(typeInfo.getTypeClass(), typeInfo.createSerializer(this.serializerConfig.get()));
    }

    @Override
    public LogicalType createLogicalType(String typeString) {
        LogicalType parsedType = LogicalTypeParser.parse(typeString, this.classLoader);
        return parsedType.accept(this.resolver);
    }

    @Override
    public LogicalType createLogicalType(UnresolvedIdentifier identifier) {
        if (!identifier.getDatabaseName().isPresent()) {
            return this.createLogicalType(identifier.getObjectName());
        }
        return this.resolveType(identifier);
    }

    private static Supplier<SerializerConfig> createSerializerConfig(ClassLoader classLoader, ReadableConfig config, SerializerConfig serializerConfig) {
        return () -> {
            SerializerConfigImpl newSerializerConfig = new SerializerConfigImpl();
            if (serializerConfig != null) {
                if (serializerConfig.isForceKryoEnabled()) {
                    newSerializerConfig.setForceKryo(true);
                }
                if (serializerConfig.isForceAvroEnabled()) {
                    newSerializerConfig.setForceAvro(true);
                }
                serializerConfig.getDefaultKryoSerializers().forEach((c, s) -> newSerializerConfig.addDefaultKryoSerializer((Class<?>)c, s.getSerializer()));
                serializerConfig.getDefaultKryoSerializerClasses().forEach(newSerializerConfig::addDefaultKryoSerializer);
                serializerConfig.getRegisteredKryoTypes().forEach(newSerializerConfig::registerKryoType);
                serializerConfig.getRegisteredTypesWithKryoSerializerClasses().forEach(newSerializerConfig::registerTypeWithKryoSerializer);
                serializerConfig.getRegisteredTypesWithKryoSerializers().forEach((c, s) -> newSerializerConfig.registerTypeWithKryoSerializer((Class<?>)c, s.getSerializer()));
            }
            newSerializerConfig.configure(config, classLoader);
            return newSerializerConfig;
        };
    }

    private LogicalType resolveType(UnresolvedIdentifier identifier) {
        assert (identifier != null);
        throw new TableException("User-defined types are not supported yet.");
    }

    private class LogicalTypeResolver
    extends LogicalTypeDuplicator {
        private LogicalTypeResolver() {
        }

        @Override
        protected LogicalType defaultMethod(LogicalType logicalType) {
            if (logicalType.is(LogicalTypeRoot.UNRESOLVED)) {
                UnresolvedUserDefinedType unresolvedType = (UnresolvedUserDefinedType)logicalType;
                return DataTypeFactoryImpl.this.resolveType(unresolvedType.getUnresolvedIdentifier()).copy(unresolvedType.isNullable());
            }
            return logicalType;
        }
    }
}

