/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.PhysicalStateHandleID;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class KeyGroupsStateHandle
implements StreamStateHandle,
KeyedStateHandle {
    private static final long serialVersionUID = -8070326169926626355L;
    private final KeyGroupRangeOffsets groupRangeOffsets;
    private final StreamStateHandle stateHandle;
    private final StateHandleID stateHandleId;

    public KeyGroupsStateHandle(KeyGroupRangeOffsets groupRangeOffsets, StreamStateHandle streamStateHandle) {
        this(groupRangeOffsets, streamStateHandle, new StateHandleID(UUID.randomUUID().toString()));
    }

    private KeyGroupsStateHandle(KeyGroupRangeOffsets groupRangeOffsets, StreamStateHandle streamStateHandle, StateHandleID stateHandleId) {
        Preconditions.checkNotNull(groupRangeOffsets);
        Preconditions.checkNotNull(streamStateHandle);
        Preconditions.checkNotNull(stateHandleId);
        this.groupRangeOffsets = groupRangeOffsets;
        this.stateHandle = streamStateHandle;
        this.stateHandleId = stateHandleId;
    }

    public static KeyGroupsStateHandle restore(KeyGroupRangeOffsets groupRangeOffsets, StreamStateHandle streamStateHandle, StateHandleID stateHandleId) {
        return new KeyGroupsStateHandle(groupRangeOffsets, streamStateHandle, stateHandleId);
    }

    public KeyGroupRangeOffsets getGroupRangeOffsets() {
        return this.groupRangeOffsets;
    }

    public StreamStateHandle getDelegateStateHandle() {
        return this.stateHandle;
    }

    public long getOffsetForKeyGroup(int keyGroupId) {
        return this.groupRangeOffsets.getKeyGroupOffset(keyGroupId);
    }

    @Override
    public KeyGroupsStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        KeyGroupRangeOffsets offsets = this.groupRangeOffsets.getIntersection(keyGroupRange);
        if (offsets.getKeyGroupRange().getNumberOfKeyGroups() <= 0) {
            return null;
        }
        return new KeyGroupsStateHandle(offsets, this.stateHandle, this.stateHandleId);
    }

    @Override
    public StateHandleID getStateHandleId() {
        return this.stateHandleId;
    }

    @Override
    public PhysicalStateHandleID getStreamStateHandleID() {
        return this.stateHandle.getStreamStateHandleID();
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.groupRangeOffsets.getKeyGroupRange();
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
    }

    @Override
    public void discardState() throws Exception {
        this.stateHandle.discardState();
    }

    @Override
    public long getStateSize() {
        return this.stateHandle.getStateSize();
    }

    @Override
    public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
        this.stateHandle.collectSizeStats(collector);
    }

    @Override
    public long getCheckpointedSize() {
        return this.getStateSize();
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.stateHandle.openInputStream();
    }

    @Override
    public Optional<byte[]> asBytesIfInMemory() {
        return this.stateHandle.asBytesIfInMemory();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyGroupsStateHandle)) {
            return false;
        }
        KeyGroupsStateHandle that = (KeyGroupsStateHandle)o;
        if (!this.groupRangeOffsets.equals(that.groupRangeOffsets)) {
            return false;
        }
        return this.stateHandle.equals(that.stateHandle);
    }

    public int hashCode() {
        int result = this.groupRangeOffsets.hashCode();
        result = 31 * result + this.stateHandle.hashCode();
        return result;
    }

    public String toString() {
        return "KeyGroupsStateHandle{groupRangeOffsets=" + this.groupRangeOffsets + ", stateHandle=" + this.stateHandle + '}';
    }
}

