/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class ConsumerVertexGroup
implements Iterable<ExecutionVertexID> {
    private final List<ExecutionVertexID> vertices;
    private final ResultPartitionType resultPartitionType;
    @Nullable
    private ConsumedPartitionGroup consumedPartitionGroup;

    private ConsumerVertexGroup(List<ExecutionVertexID> vertices, ResultPartitionType resultPartitionType) {
        this.vertices = vertices;
        this.resultPartitionType = resultPartitionType;
    }

    public static ConsumerVertexGroup fromMultipleVertices(List<ExecutionVertexID> vertices, ResultPartitionType resultPartitionType) {
        return new ConsumerVertexGroup(vertices, resultPartitionType);
    }

    public static ConsumerVertexGroup fromSingleVertex(ExecutionVertexID vertex, ResultPartitionType resultPartitionType) {
        return new ConsumerVertexGroup(Collections.singletonList(vertex), resultPartitionType);
    }

    public ResultPartitionType getResultPartitionType() {
        return this.resultPartitionType;
    }

    @Override
    public Iterator<ExecutionVertexID> iterator() {
        return this.vertices.iterator();
    }

    public int size() {
        return this.vertices.size();
    }

    public boolean isEmpty() {
        return this.vertices.isEmpty();
    }

    public ExecutionVertexID getFirst() {
        return this.iterator().next();
    }

    public ConsumedPartitionGroup getConsumedPartitionGroup() {
        return Preconditions.checkNotNull(this.consumedPartitionGroup, "ConsumedPartitionGroup is not properly set.");
    }

    public void setConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup) {
        Preconditions.checkState(this.consumedPartitionGroup == null);
        this.consumedPartitionGroup = Preconditions.checkNotNull(consumedPartitionGroup);
    }
}

