/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class ProfilingInfoList
implements ResponseBody,
Serializable {
    public static final String FIELD_NAME_FLAME_GRAPHS = "profilingList";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="profilingList")
    private final Collection<ProfilingInfo> profilingInfos;

    @JsonCreator
    public ProfilingInfoList(@JsonProperty(value="profilingList") Collection<ProfilingInfo> profilingInfos) {
        this.profilingInfos = Preconditions.checkNotNull(profilingInfos);
    }

    public Collection<ProfilingInfo> getProfilingInfos() {
        return this.profilingInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfilingInfoList that = (ProfilingInfoList)o;
        return Objects.equals(this.profilingInfos, that.profilingInfos);
    }

    public int hashCode() {
        return Objects.hash(this.profilingInfos);
    }

    public static ProfilingInfoList empty() {
        return new ProfilingInfoList(Collections.emptyList());
    }

    public static ProfilingInfoList createNullable(Collection<ProfilingInfo> profilingInfos) {
        if (CollectionUtil.isNullOrEmpty(profilingInfos)) {
            return ProfilingInfoList.empty();
        }
        return new ProfilingInfoList(profilingInfos);
    }
}

