/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.forwardgroup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.VertexGroupComputeUtil;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.forwardgroup.ForwardGroup;
import org.apache.flink.util.Preconditions;

public class ForwardGroupComputeUtil {
    public static Map<JobVertexID, ForwardGroup> computeForwardGroupsAndCheckParallelism(Iterable<JobVertex> topologicallySortedVertices) {
        Map<JobVertexID, ForwardGroup> forwardGroupsByJobVertexId = ForwardGroupComputeUtil.computeForwardGroups(topologicallySortedVertices, ForwardGroupComputeUtil::getForwardProducers);
        topologicallySortedVertices.forEach(jobVertex -> {
            ForwardGroup forwardGroup = (ForwardGroup)forwardGroupsByJobVertexId.get(jobVertex.getID());
            if (forwardGroup != null && forwardGroup.isParallelismDecided()) {
                Preconditions.checkState(jobVertex.getParallelism() == forwardGroup.getParallelism());
            }
        });
        return forwardGroupsByJobVertexId;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<JobVertexID, ForwardGroup> computeForwardGroups(Iterable<JobVertex> topologicallySortedVertices, Function<JobVertex, Set<JobVertex>> forwardProducersRetriever) {
        IdentityHashMap vertexToGroup = new IdentityHashMap();
        for (JobVertex vertex : topologicallySortedVertices) {
            HashSet<JobVertex> hashSet = new HashSet<JobVertex>();
            hashSet.add(vertex);
            vertexToGroup.put(vertex, hashSet);
            for (JobVertex producerVertex : forwardProducersRetriever.apply(vertex)) {
                void var5_5;
                Set producerGroup = (Set)vertexToGroup.get(producerVertex);
                if (producerGroup == null) {
                    throw new IllegalStateException("Producer task " + producerVertex.getID() + " forward group is null while calculating forward group for the consumer task " + vertex.getID() + ". This should be a forward group building bug.");
                }
                if (var5_5 == producerGroup) continue;
                Set set = VertexGroupComputeUtil.mergeVertexGroups(var5_5, producerGroup, vertexToGroup);
            }
        }
        HashMap<JobVertexID, ForwardGroup> ret = new HashMap<JobVertexID, ForwardGroup>();
        for (Set<JobVertex> set : VertexGroupComputeUtil.uniqueVertexGroups(vertexToGroup)) {
            if (set.size() <= 1) continue;
            ForwardGroup forwardGroup = new ForwardGroup(set);
            for (JobVertexID jobVertexId : forwardGroup.getJobVertexIds()) {
                ret.put(jobVertexId, forwardGroup);
            }
        }
        return ret;
    }

    static Set<JobVertex> getForwardProducers(JobVertex jobVertex) {
        return jobVertex.getInputs().stream().filter(JobEdge::isForward).map(JobEdge::getSource).map(IntermediateDataSet::getProducer).collect(Collectors.toSet());
    }
}

