/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.debezium;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.JsonFormatOptionsUtil;
import org.apache.flink.formats.json.debezium.DebeziumJsonDecodingFormat;
import org.apache.flink.formats.json.debezium.DebeziumJsonFormatOptions;
import org.apache.flink.formats.json.debezium.DebeziumJsonSerializationSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

@Internal
public class DebeziumJsonFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "debezium-json";

    @Override
    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions(this, formatOptions);
        DebeziumJsonFormatFactory.validateDecodingFormatOptions(formatOptions);
        boolean schemaInclude = formatOptions.get(DebeziumJsonFormatOptions.SCHEMA_INCLUDE);
        boolean ignoreParseErrors = formatOptions.get(DebeziumJsonFormatOptions.IGNORE_PARSE_ERRORS);
        TimestampFormat timestampFormat = JsonFormatOptionsUtil.getTimestampFormat(formatOptions);
        return new DebeziumJsonDecodingFormat(schemaInclude, ignoreParseErrors, timestampFormat);
    }

    @Override
    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions(this, formatOptions);
        DebeziumJsonFormatFactory.validateEncodingFormatOptions(formatOptions);
        final TimestampFormat timestampFormat = JsonFormatOptionsUtil.getTimestampFormat(formatOptions);
        final JsonFormatOptions.MapNullKeyMode mapNullKeyMode = JsonFormatOptionsUtil.getMapNullKeyMode(formatOptions);
        final String mapNullKeyLiteral = formatOptions.get(DebeziumJsonFormatOptions.JSON_MAP_NULL_KEY_LITERAL);
        final boolean encodeDecimalAsPlainNumber = formatOptions.get(JsonFormatOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            @Override
            public ChangelogMode getChangelogMode() {
                return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
            }

            @Override
            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                return new DebeziumJsonSerializationSchema(rowType, timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber);
            }
        };
    }

    @Override
    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(DebeziumJsonFormatOptions.SCHEMA_INCLUDE);
        options.add(DebeziumJsonFormatOptions.IGNORE_PARSE_ERRORS);
        options.add(DebeziumJsonFormatOptions.TIMESTAMP_FORMAT);
        options.add(DebeziumJsonFormatOptions.JSON_MAP_NULL_KEY_MODE);
        options.add(DebeziumJsonFormatOptions.JSON_MAP_NULL_KEY_LITERAL);
        options.add(JsonFormatOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return options;
    }

    private static void validateDecodingFormatOptions(ReadableConfig tableOptions) {
        JsonFormatOptionsUtil.validateDecodingFormatOptions(tableOptions);
    }

    private static void validateEncodingFormatOptions(ReadableConfig tableOptions) {
        JsonFormatOptionsUtil.validateEncodingFormatOptions(tableOptions);
        if (tableOptions.get(DebeziumJsonFormatOptions.SCHEMA_INCLUDE).booleanValue()) {
            throw new ValidationException(String.format("Debezium JSON serialization doesn't support '%s.%s' option been set to true.", IDENTIFIER, DebeziumJsonFormatOptions.SCHEMA_INCLUDE.key()));
        }
    }
}

