/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.flink.table.jdbc.utils.DriverUtils;

public class DriverUri {
    private static final String URL_PREFIX = "jdbc:";
    private static final String URL_START = "jdbc:flink:";
    private final InetSocketAddress address;
    private final URI uri;
    private final Properties properties;
    private Optional<String> catalog = Optional.empty();
    private Optional<String> database = Optional.empty();

    private DriverUri(String url, Properties driverProperties) throws SQLException {
        this(DriverUri.parseDriverUrl(url), driverProperties);
    }

    private DriverUri(URI uri, Properties driverProperties) throws SQLException {
        this.uri = DriverUtils.checkNotNull(uri, "uri is null");
        this.address = new InetSocketAddress(uri.getHost(), uri.getPort());
        this.properties = DriverUri.mergeDynamicProperties(uri, driverProperties);
        this.initCatalogAndSchema();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getDatabase() {
        return this.database;
    }

    public String getURL() {
        return String.format("%s%s", URL_PREFIX, this.uri);
    }

    private void initCatalogAndSchema() throws SQLException {
        String path = this.uri.getPath();
        if (DriverUtils.isNullOrWhitespaceOnly(this.uri.getPath()) || path.equals("/")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new SQLException("Path in uri does not start with a slash: " + this.uri);
        }
        List parts = Arrays.stream((path = path.substring(1)).split("/")).collect(Collectors.toList());
        if (((String)parts.get(parts.size() - 1)).isEmpty()) {
            parts = parts.subList(0, parts.size() - 1);
        }
        if (parts.size() > 2) {
            throw new SQLException("Invalid path segments in URL: " + this.uri);
        }
        if (((String)parts.get(0)).isEmpty()) {
            throw new SQLException("Catalog name in URL is empty: " + this.uri);
        }
        this.catalog = Optional.ofNullable(parts.get(0));
        if (parts.size() > 1) {
            if (((String)parts.get(1)).isEmpty()) {
                throw new SQLException("Database name in URL is empty: " + this.uri);
            }
            this.database = Optional.ofNullable(parts.get(1));
        }
    }

    private static Properties mergeDynamicProperties(URI uri, Properties driverProperties) throws SQLException {
        Map<String, String> urlProperties = DriverUri.parseUriParameters(uri.getQuery());
        Map<String, String> suppliedProperties = DriverUtils.fromProperties(driverProperties);
        for (String key : urlProperties.keySet()) {
            if (!suppliedProperties.containsKey(key)) continue;
            throw new SQLException(String.format("Connection property '%s' is both in the URL and an argument", key));
        }
        Properties result = new Properties();
        DriverUri.addMapToProperties(result, urlProperties);
        DriverUri.addMapToProperties(result, suppliedProperties);
        return result;
    }

    private static void addMapToProperties(Properties properties, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static Map<String, String> parseUriParameters(String query) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query != null) {
            String[] queryArgs;
            for (String queryArg : queryArgs = query.split("&")) {
                String[] parts = queryArg.split("=");
                if (parts.length != 2) {
                    throw new SQLException(String.format("Connection property in uri must be key=val format: '%s'", queryArg));
                }
                if (result.put(parts[0], parts[1]) == null) continue;
                throw new SQLException(String.format("Connection property '%s' is in URL multiple times", parts[0]));
            }
        }
        return result;
    }

    private static URI parseDriverUrl(String url) throws SQLException {
        URI uri;
        if (!url.startsWith(URL_START)) {
            throw new SQLException(String.format("Flink JDBC URL[%s] must start with [%s]", url, URL_START));
        }
        if (url.equals(URL_START)) {
            throw new SQLException(String.format("Empty Flink JDBC URL: %s", url));
        }
        try {
            uri = new URI(url.substring(URL_PREFIX.length()));
        }
        catch (URISyntaxException e) {
            throw new SQLException(String.format("Invalid Flink JDBC URL: %s", url), e);
        }
        if (DriverUtils.isNullOrWhitespaceOnly(uri.getHost())) {
            throw new SQLException(String.format("No host specified in uri: %s", url));
        }
        if (uri.getPort() == -1) {
            throw new SQLException(String.format("No port specified in uri: %s", url));
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException(String.format("Port must be [1, 65535] in uri: %s", url));
        }
        return uri;
    }

    public static boolean acceptsURL(String url) {
        return url.startsWith(URL_START);
    }

    public static DriverUri create(String url, Properties properties) throws SQLException {
        return new DriverUri(url, properties == null ? new Properties() : properties);
    }
}

