/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.RowDataToJsonConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;
import org.apache.flink.table.gateway.rest.util.RowFormat;

@Internal
public class ResultInfoSerializer
extends StdSerializer<ResultInfo> {
    public static final String FIELD_NAME_COLUMN_INFOS = "columns";
    public static final String FIELD_NAME_DATA = "data";
    public static final String FIELD_NAME_KIND = "kind";
    public static final String FIELD_NAME_FIELDS = "fields";
    public static final String FIELD_NAME_ROW_FORMAT = "rowFormat";
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final RowDataToJsonConverters TO_JSON_CONVERTERS = new RowDataToJsonConverters(TimestampFormat.ISO_8601, JsonFormatOptions.MapNullKeyMode.LITERAL, "null");

    public ResultInfoSerializer() {
        super(ResultInfo.class);
    }

    @Override
    public void serialize(ResultInfo resultInfo, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        serializerProvider.defaultSerializeField(FIELD_NAME_COLUMN_INFOS, resultInfo.getColumnInfos(), jsonGenerator);
        serializerProvider.defaultSerializeField(FIELD_NAME_ROW_FORMAT, (Object)resultInfo.getRowFormat(), jsonGenerator);
        this.serializeData(resultInfo.getData(), this.buildRowDataConverters(resultInfo), jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private void serializeData(List<RowData> data, List<Function<RowData, JsonNode>> converters, JsonGenerator jsonGenerator) throws IOException {
        ArrayNode serializedData = OBJECT_MAPPER.createArrayNode();
        serializedData.addAll(data.stream().map(rowData -> this.convertRowData((RowData)rowData, converters)).collect(Collectors.toList()));
        jsonGenerator.writeFieldName(FIELD_NAME_DATA);
        jsonGenerator.writeTree(serializedData);
    }

    private JsonNode convertRowData(RowData rowData, List<Function<RowData, JsonNode>> converters) {
        ObjectNode serializedRowData = OBJECT_MAPPER.createObjectNode();
        serializedRowData.put(FIELD_NAME_KIND, rowData.getRowKind().name());
        ArrayNode fields = serializedRowData.putArray(FIELD_NAME_FIELDS);
        fields.addAll(converters.stream().map(converter -> (JsonNode)converter.apply(rowData)).collect(Collectors.toList()));
        return serializedRowData;
    }

    private List<Function<RowData, JsonNode>> buildRowDataConverters(ResultInfo resultInfo) {
        RowFormat rowFormat = resultInfo.getRowFormat();
        List<RowData.FieldGetter> fieldGetters = resultInfo.getFieldGetters();
        if (rowFormat == RowFormat.JSON) {
            List converters = resultInfo.getColumnInfos().stream().map(ColumnInfo::getLogicalType).map(TO_JSON_CONVERTERS::createConverter).collect(Collectors.toList());
            return IntStream.range(0, converters.size()).mapToObj(i -> rowData -> ((RowDataToJsonConverters.RowDataToJsonConverter)converters.get(i)).convert(OBJECT_MAPPER, null, ((RowData.FieldGetter)fieldGetters.get(i)).getFieldOrNull((RowData)rowData))).collect(Collectors.toList());
        }
        if (rowFormat == RowFormat.PLAIN_TEXT) {
            return IntStream.range(0, resultInfo.getColumnInfos().size()).mapToObj(i -> rowData -> {
                Object value = ((RowData.FieldGetter)fieldGetters.get(i)).getFieldOrNull((RowData)rowData);
                return value == null ? OBJECT_MAPPER.getNodeFactory().nullNode() : OBJECT_MAPPER.getNodeFactory().textNode(value.toString());
            }).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException(String.format("Unknown row format: %s.", new Object[]{rowFormat}));
    }
}

