/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.client.cli.CliInputView;
import org.apache.flink.table.client.cli.CliResultView;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.result.MaterializedResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.print.PrintStyle;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class CliTableResultView
extends CliResultView<ResultTableOperation> {
    private int pageCount;
    private int page;
    private LocalTime lastRetrieval;
    private int previousResultsPage;
    private final MaterializedResult materializedResult;
    private static final int DEFAULT_REFRESH_INTERVAL = 3;
    private static final int MIN_REFRESH_INTERVAL = 1;
    private static final int LAST_PAGE = 0;

    public CliTableResultView(Terminal terminal, ResultDescriptor resultDescriptor) {
        this(terminal, resultDescriptor, (MaterializedResult)resultDescriptor.createResult());
    }

    @VisibleForTesting
    public CliTableResultView(Terminal terminal, ResultDescriptor resultDescriptor, MaterializedResult materializedResult) {
        super(terminal, resultDescriptor, PrintStyle.tableauWithTypeInferredColumnWidths(resultDescriptor.getResultSchema(), resultDescriptor.getRowDataStringConverter(), resultDescriptor.maxColumnWidth(), false, false));
        this.refreshInterval = 3;
        this.pageCount = 1;
        this.page = 0;
        this.materializedResult = materializedResult;
        this.previousResults = Collections.emptyList();
        this.previousResultsPage = 1;
        this.results = Collections.emptyList();
    }

    @Override
    protected String[] getRow(String[] resultRow) {
        return resultRow;
    }

    @Override
    void cleanUpQuery() {
        this.materializedResult.close();
    }

    @Override
    protected void refresh() {
        TypedResult<Integer> result;
        try {
            result = this.materializedResult.snapshot(this.getVisibleMainHeight());
        }
        catch (SqlExecutionException e) {
            this.close(e);
            return;
        }
        if (result.getType() == TypedResult.ResultType.EOS) {
            this.stopRetrieval(false);
        } else if (result.getType() == TypedResult.ResultType.PAYLOAD) {
            int newPageCount;
            this.pageCount = newPageCount = result.getPayload().intValue();
            if (this.page > newPageCount) {
                this.page = 0;
            }
            this.updatePage();
        }
        this.lastRetrieval = LocalTime.now();
        this.resetAllParts();
    }

    @Override
    protected KeyMap<ResultTableOperation> getKeys() {
        KeyMap<ResultTableOperation> keys = new KeyMap<ResultTableOperation>();
        keys.setAmbiguousTimeout(200L);
        keys.bind(ResultTableOperation.QUIT, "q", "Q", KeyMap.esc(), KeyMap.ctrl('c'));
        keys.bind(ResultTableOperation.REFRESH, "r", "R", KeyMap.key(this.terminal, InfoCmp.Capability.key_f5));
        keys.bind(ResultTableOperation.UP, "w", "W", KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        keys.bind(ResultTableOperation.DOWN, "s", "S", KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        keys.bind(ResultTableOperation.LEFT, "a", "A", KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        keys.bind(ResultTableOperation.RIGHT, "d", "D", KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        keys.bind(ResultTableOperation.OPEN, "o", "O", "\r");
        keys.bind(ResultTableOperation.GOTO, "g", "G");
        keys.bind(ResultTableOperation.NEXT, "n", "N");
        keys.bind(ResultTableOperation.PREV, "p", "P");
        keys.bind(ResultTableOperation.LAST, "l", "L", KeyMap.key(this.terminal, InfoCmp.Capability.key_end));
        keys.bind(ResultTableOperation.INC_REFRESH, (CharSequence)"+");
        keys.bind(ResultTableOperation.DEC_REFRESH, (CharSequence)"-");
        return keys;
    }

    @Override
    protected void evaluate(ResultTableOperation operation, String binding) {
        switch (operation) {
            case QUIT: {
                this.close();
                break;
            }
            case REFRESH: {
                this.refresh();
                break;
            }
            case UP: {
                this.selectRowUp();
                break;
            }
            case DOWN: {
                this.selectRowDown();
                break;
            }
            case OPEN: {
                this.openRow();
                break;
            }
            case GOTO: {
                this.gotoPage();
                break;
            }
            case NEXT: {
                this.gotoNextPage();
                break;
            }
            case PREV: {
                this.gotoPreviousPage();
                break;
            }
            case LAST: {
                this.gotoLastPage();
                break;
            }
            case LEFT: {
                this.scrollLeft();
                break;
            }
            case RIGHT: {
                this.scrollRight();
                break;
            }
            case INC_REFRESH: {
                this.increaseRefreshInterval();
                break;
            }
            case DEC_REFRESH: {
                this.decreaseRefreshInterval(1);
            }
        }
    }

    @Override
    protected String getTitle() {
        return "SQL Query Result (Table)";
    }

    @Override
    protected List<AttributedString> computeHeaderLines() {
        AttributedStringBuilder statusLine = new AttributedStringBuilder();
        statusLine.style(AttributedStyle.INVERSE);
        String left = this.isRetrieving() ? " Refresh: " + (String)((Tuple2)CliTableResultView.REFRESH_INTERVALS.get((int)this.refreshInterval)).f0 : " Table program finished.";
        StringBuilder middleBuilder = new StringBuilder();
        middleBuilder.append("Page:");
        middleBuilder.append(' ');
        if (this.page == 0) {
            middleBuilder.append("Last");
        } else {
            middleBuilder.append(this.page);
        }
        middleBuilder.append(" of ");
        middleBuilder.append(this.pageCount);
        String middle = middleBuilder.toString();
        String right = this.lastRetrieval == null ? "Updated: Unknown " : "Updated: " + this.lastRetrieval.format(CliUtils.TIME_FORMATTER) + " ";
        int totalLeftSpace = this.getWidth() - middle.length();
        int leftSpace = totalLeftSpace / 2 - left.length();
        statusLine.append(left);
        CliUtils.repeatChar(statusLine, ' ', leftSpace);
        statusLine.append(middle);
        int rightSpacing = this.getWidth() - statusLine.length() - right.length();
        CliUtils.repeatChar(statusLine, ' ', rightSpacing);
        statusLine.append(right);
        return Arrays.asList(statusLine.toAttributedString(), AttributedString.EMPTY);
    }

    @Override
    protected List<AttributedString> computeMainHeaderLines() {
        AttributedStringBuilder schemaHeader = new AttributedStringBuilder();
        IntStream.range(0, this.resultDescriptor.getResultSchema().getColumnCount()).forEach(idx -> {
            schemaHeader.style(AttributedStyle.DEFAULT);
            schemaHeader.append(' ');
            String columnName = this.resultDescriptor.getResultSchema().getColumnNames().get(idx);
            schemaHeader.style(AttributedStyle.DEFAULT.underline());
            CliUtils.normalizeColumn(schemaHeader, columnName, this.columnWidths[idx]);
        });
        return Collections.singletonList(schemaHeader.toAttributedString());
    }

    @Override
    protected List<AttributedString> computeFooterLines() {
        return CliUtils.formatTwoLineHelpOptions(this.getWidth(), this.getHelpOptions());
    }

    private void updatePage() {
        List<RowData> rows;
        int retrievalPage = this.page == 0 ? this.pageCount : this.page;
        try {
            rows = this.materializedResult.retrievePage(retrievalPage);
        }
        catch (SqlExecutionException e) {
            this.close(e);
            return;
        }
        List stringRows = rows.stream().map(this.resultDescriptor.getRowDataStringConverter()::convert).collect(Collectors.toList());
        if (this.previousResultsPage == retrievalPage) {
            this.previousResults = this.results;
        } else {
            this.previousResults = null;
            this.previousResultsPage = retrievalPage;
        }
        this.results = stringRows;
        if (this.selectedRow != -1 && this.selectedRow >= this.results.size()) {
            this.selectedRow = -1;
        }
        this.resetAllParts();
    }

    private List<Tuple2<String, String>> getHelpOptions() {
        ArrayList<Tuple2<String, String>> options = new ArrayList<Tuple2<String, String>>();
        options.add(Tuple2.of("Q", "Quit"));
        options.add(Tuple2.of("R", "Refresh"));
        options.add(Tuple2.of("+", "Inc Refresh"));
        options.add(Tuple2.of("-", "Dec Refresh"));
        options.add(Tuple2.of("G", "Goto Page"));
        options.add(Tuple2.of("L", "Last Page"));
        options.add(Tuple2.of("N", "Next Page"));
        options.add(Tuple2.of("P", "Prev Page"));
        options.add(Tuple2.of("O", "Open Row"));
        return options;
    }

    private void gotoPage() {
        CliInputView view = new CliInputView(this.terminal, "Enter page number: [1 to " + this.pageCount + "]", s -> {
            int newPage;
            try {
                newPage = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return newPage > 0 && newPage <= this.pageCount;
        });
        view.open();
        if (view.getResult() != null) {
            this.page = Integer.parseInt((String)view.getResult());
            this.updatePage();
        }
    }

    private void gotoNextPage() {
        int curPageIndex;
        int n = curPageIndex = this.page == 0 ? this.pageCount : this.page;
        if (curPageIndex < this.pageCount) {
            this.page = curPageIndex + 1;
        }
        this.updatePage();
    }

    private void gotoPreviousPage() {
        int curPageIndex;
        int n = curPageIndex = this.page == 0 ? this.pageCount : this.page;
        if (curPageIndex > 1) {
            this.page = curPageIndex - 1;
        }
        this.updatePage();
    }

    private void gotoLastPage() {
        this.page = 0;
        this.updatePage();
    }

    public static enum ResultTableOperation {
        QUIT,
        REFRESH,
        UP,
        DOWN,
        OPEN,
        GOTO,
        NEXT,
        PREV,
        LAST,
        LEFT,
        RIGHT,
        INC_REFRESH,
        DEC_REFRESH;

    }
}

