/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.taskmanager.AbstractTaskManagerFileHandler;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;

public class TaskManagerStdoutFileHandler
extends AbstractTaskManagerFileHandler<TaskManagerMessageParameters> {
    @VisibleForTesting
    static final String FILE_NOT_FOUND_INFO = "The file STDOUT does not exist on the TaskExecutor. \nIf you are using kubernetes mode, please use \"kubectl logs <pod-name>\" to get stdout content.";

    public TaskManagerStdoutFileHandler(@Nonnull GatewayRetriever<? extends RestfulGateway> leaderRetriever, @Nonnull Time timeout, @Nonnull Map<String, String> responseHeaders, @Nonnull UntypedResponseMessageHeaders<EmptyRequestBody, TaskManagerMessageParameters> untypedResponseMessageHeaders, @Nonnull GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, @Nonnull TransientBlobService transientBlobService, @Nonnull Time cacheEntryDuration) {
        super(leaderRetriever, timeout, responseHeaders, untypedResponseMessageHeaders, resourceManagerGatewayRetriever, transientBlobService, cacheEntryDuration);
    }

    @Override
    protected CompletableFuture<TransientBlobKey> requestFileUpload(ResourceManagerGateway resourceManagerGateway, Tuple2<ResourceID, String> taskManagerIdAndFileName) {
        return resourceManagerGateway.requestTaskManagerFileUploadByType((ResourceID)taskManagerIdAndFileName.f0, FileType.STDOUT, this.timeout);
    }

    @Override
    protected CompletableFuture<Void> handleException(ChannelHandlerContext ctx, HttpRequest httpRequest, Throwable throwable, ResourceID taskManagerId) {
        Throwable strippedThrowable = ExceptionUtils.stripCompletionException(throwable);
        if (strippedThrowable instanceof FileNotFoundException) {
            return HandlerUtils.sendResponse(ctx, httpRequest, FILE_NOT_FOUND_INFO, HttpResponseStatus.OK, Collections.emptyMap());
        }
        return super.handleException(ctx, httpRequest, throwable, taskManagerId);
    }
}

