/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.operation;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.operation.OperationHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.operation.OperationMessageParameters;
import org.apache.flink.table.gateway.rest.message.operation.OperationStatusResponseBody;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public abstract class AbstractOperationHandler
extends AbstractSqlGatewayRestHandler<EmptyRequestBody, OperationStatusResponseBody, OperationMessageParameters> {
    public AbstractOperationHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, OperationStatusResponseBody, OperationMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    protected String getStatus(SessionHandle sessionHandle, OperationHandle operationHandle) {
        return this.service.getOperationInfo(sessionHandle, operationHandle).getStatus().toString();
    }

    protected void execute(SessionHandle sessionHandle, OperationHandle operationHandle) {
    }

    @Override
    protected CompletableFuture<OperationStatusResponseBody> handleRequest(SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<EmptyRequestBody> request) throws RestHandlerException {
        try {
            SessionHandle sessionHandle = (SessionHandle)request.getPathParameter(SessionHandleIdPathParameter.class);
            OperationHandle operationHandle = (OperationHandle)request.getPathParameter(OperationHandleIdPathParameter.class);
            this.execute(sessionHandle, operationHandle);
            String status = this.getStatus(sessionHandle, operationHandle);
            return CompletableFuture.completedFuture(new OperationStatusResponseBody(status));
        }
        catch (SqlGatewayException e) {
            throw new RestHandlerException(e.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

