/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.session;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.session.CloseSessionResponseBody;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.session.SessionMessageParameters;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class CloseSessionHandler
extends AbstractSqlGatewayRestHandler<EmptyRequestBody, CloseSessionResponseBody, SessionMessageParameters> {
    public static final String CLOSE_MESSAGE = "CLOSED";

    public CloseSessionHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, CloseSessionResponseBody, SessionMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<CloseSessionResponseBody> handleRequest(SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<EmptyRequestBody> request) throws RestHandlerException {
        try {
            SessionHandle sessionHandle = (SessionHandle)request.getPathParameter(SessionHandleIdPathParameter.class);
            this.service.closeSession(sessionHandle);
            return CompletableFuture.completedFuture(new CloseSessionResponseBody(CLOSE_MESSAGE));
        }
        catch (SqlGatewayException e) {
            throw new RestHandlerException(e.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

