/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.operation;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.internal.CachedPlan;
import org.apache.flink.table.api.internal.ExecutableOperationContextImpl;
import org.apache.flink.table.api.internal.PlanCacheManager;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.FunctionInfo;
import org.apache.flink.table.gateway.api.results.TableInfo;
import org.apache.flink.table.gateway.environment.SqlGatewayStreamExecutionEnvironment;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.gateway.service.utils.SqlExecutionException;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.BeginStatementSetOperation;
import org.apache.flink.table.operations.CallProcedureOperation;
import org.apache.flink.table.operations.CompileAndExecutePlanOperation;
import org.apache.flink.table.operations.DeleteFromFilterOperation;
import org.apache.flink.table.operations.EndStatementSetOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.LoadModuleOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.table.operations.UnloadModuleOperation;
import org.apache.flink.table.operations.UseOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.ExecutePlanOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.operations.command.ShowJobsOperation;
import org.apache.flink.table.operations.command.StopJobOperation;
import org.apache.flink.table.operations.ddl.AlterOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropOperation;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OperationExecutor.class);
    protected final SessionContext sessionContext;
    private final Configuration executionConfig;
    private final ClusterClientServiceLoader clusterClientServiceLoader;

    @VisibleForTesting
    public OperationExecutor(SessionContext context, Configuration executionConfig) {
        this.sessionContext = context;
        this.executionConfig = executionConfig;
        this.clusterClientServiceLoader = new DefaultClusterClientServiceLoader();
    }

    public ResultFetcher configureSession(OperationHandle handle, String statement) {
        TableEnvironmentInternal tableEnv = this.getTableEnvironment();
        List parsedOperations = tableEnv.getParser().parse(statement);
        if (parsedOperations.size() > 1) {
            throw new UnsupportedOperationException("Unsupported SQL statement! Configure session only accepts a single SQL statement.");
        }
        Operation op = (Operation)parsedOperations.get(0);
        if (!(op instanceof SetOperation || op instanceof ResetOperation || op instanceof CreateOperation || op instanceof DropOperation || op instanceof UseOperation || op instanceof AlterOperation || op instanceof LoadModuleOperation || op instanceof UnloadModuleOperation || op instanceof AddJarOperation)) {
            throw new UnsupportedOperationException(String.format("Unsupported statement for configuring session:%s\nThe configureSession API only supports to execute statement of type CREATE TABLE, DROP TABLE, ALTER TABLE, CREATE DATABASE, DROP DATABASE, ALTER DATABASE, CREATE FUNCTION, DROP FUNCTION, ALTER FUNCTION, CREATE CATALOG, DROP CATALOG, USE CATALOG, USE [CATALOG.]DATABASE, CREATE VIEW, DROP VIEW, LOAD MODULE, UNLOAD MODULE, USE MODULE, ADD JAR.", statement));
        }
        if (op instanceof SetOperation) {
            return this.callSetOperation(tableEnv, handle, (SetOperation)op);
        }
        if (op instanceof ResetOperation) {
            return this.callResetOperation(handle, (ResetOperation)op);
        }
        return this.callOperation(tableEnv, handle, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultFetcher executeStatement(OperationHandle handle, String statement) {
        Optional cachedPlanOptional;
        ResourceManager resourceManager = this.sessionContext.getSessionState().resourceManager.copy();
        TableEnvironmentInternal tableEnv = this.getTableEnvironment(resourceManager);
        PlanCacheManager planCacheManager = this.sessionContext.getPlanCacheManager();
        CachedPlan cachedPlan = null;
        Operation op = null;
        if (planCacheManager != null && (cachedPlanOptional = planCacheManager.getPlan(statement)).isPresent()) {
            cachedPlan = (CachedPlan)cachedPlanOptional.get();
            op = cachedPlan.getOperation();
        }
        if (op == null) {
            List parsedOperations = tableEnv.getParser().parse(statement);
            if (parsedOperations.size() > 1) {
                throw new UnsupportedOperationException("Unsupported SQL statement! Execute statement only accepts a single SQL statement or multiple 'INSERT INTO' statements wrapped in a 'STATEMENT SET' block.");
            }
            op = (Operation)parsedOperations.get(0);
        }
        if (op instanceof CallProcedureOperation) {
            try {
                SqlGatewayStreamExecutionEnvironment.setAsContext(this.sessionContext.getUserClassloader());
                ResultFetcher resultFetcher = this.executeOperation(tableEnv, handle, op, statement, cachedPlan).withResourceManager(resourceManager);
                return resultFetcher;
            }
            finally {
                SqlGatewayStreamExecutionEnvironment.unsetAsContext();
            }
        }
        return this.sessionContext.isStatementSetState() ? this.executeOperationInStatementSetState(tableEnv, handle, op).withResourceManager(resourceManager) : this.executeOperation(tableEnv, handle, op, statement, cachedPlan).withResourceManager(resourceManager);
    }

    public String getCurrentCatalog() {
        return this.sessionContext.getSessionState().catalogManager.getCurrentCatalog();
    }

    public Set<String> listCatalogs() {
        return this.sessionContext.getSessionState().catalogManager.listCatalogs();
    }

    public Set<String> listDatabases(String catalogName) {
        return new HashSet<String>(((Catalog)this.sessionContext.getSessionState().catalogManager.getCatalog(catalogName).orElseThrow(() -> new CatalogNotExistException(String.format("Catalog '%s' does not exist.", catalogName)))).listDatabases());
    }

    public Set<TableInfo> listTables(String catalogName, String databaseName, Set<CatalogBaseTable.TableKind> tableKinds) {
        Preconditions.checkArgument((boolean)Arrays.asList(CatalogBaseTable.TableKind.TABLE, CatalogBaseTable.TableKind.VIEW).containsAll(tableKinds), (Object)"Currently only support to list TABLE, VIEW or TABLE AND VIEW.");
        if (tableKinds.contains(CatalogBaseTable.TableKind.TABLE) && tableKinds.contains(CatalogBaseTable.TableKind.VIEW)) {
            return this.listTables(catalogName, databaseName, true);
        }
        if (tableKinds.contains(CatalogBaseTable.TableKind.TABLE)) {
            return this.listTables(catalogName, databaseName, false);
        }
        return this.listViews(catalogName, databaseName);
    }

    public ResolvedCatalogBaseTable<?> getTable(ObjectIdentifier tableIdentifier) {
        return this.getTableEnvironment().getCatalogManager().getTableOrError(tableIdentifier).getResolvedTable();
    }

    public Set<FunctionInfo> listUserDefinedFunctions(String catalogName, String databaseName) {
        return this.sessionContext.getSessionState().functionCatalog.getUserDefinedFunctions(catalogName, databaseName).stream().map(FunctionInfo::new).collect(Collectors.toSet());
    }

    public Set<FunctionInfo> listSystemFunctions() {
        HashSet<FunctionInfo> info = new HashSet<FunctionInfo>();
        for (String functionName : this.sessionContext.getSessionState().moduleManager.listFunctions()) {
            try {
                info.add(this.sessionContext.getSessionState().moduleManager.getFunctionDefinition(functionName).map(definition -> new FunctionInfo(FunctionIdentifier.of((String)functionName), definition.getKind())).orElse(new FunctionInfo(FunctionIdentifier.of((String)functionName))));
            }
            catch (Throwable t) {
                LOG.error(String.format("Failed to load the system function `%s`.", functionName), t);
            }
        }
        return info;
    }

    public FunctionDefinition getFunctionDefinition(UnresolvedIdentifier identifier) {
        return ((ContextResolvedFunction)this.sessionContext.getSessionState().functionCatalog.lookupFunction(identifier).orElseThrow(() -> new IllegalArgumentException(String.format("Can not find the definition: %s.", identifier.asSummaryString())))).getDefinition();
    }

    public ResultFetcher getCompletionHints(OperationHandle operationHandle, String statement, int position) {
        return ResultFetcher.fromResults(operationHandle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"candidates", (DataType)DataTypes.STRING())}), Arrays.stream(this.getTableEnvironment().getParser().getCompletionHints(statement, position)).map(hint -> GenericRowData.of((Object[])new Object[]{StringData.fromString((String)hint)})).collect(Collectors.toList()));
    }

    public TableEnvironmentInternal getTableEnvironment() {
        return this.getTableEnvironment(this.sessionContext.getSessionState().resourceManager);
    }

    public TableEnvironmentInternal getTableEnvironment(ResourceManager resourceManager) {
        Configuration operationConfig = this.sessionContext.getSessionConf().clone();
        operationConfig.addAll(this.executionConfig);
        EnvironmentSettings settings = EnvironmentSettings.newInstance().withConfiguration(operationConfig).build();
        StreamExecutionEnvironment streamExecEnv = new StreamExecutionEnvironment(operationConfig, (ClassLoader)this.sessionContext.getUserClassloader());
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setRootConfiguration((ReadableConfig)this.sessionContext.getDefaultContext().getFlinkConfig());
        tableConfig.addConfiguration(operationConfig);
        Executor executor = OperationExecutor.lookupExecutor(streamExecEnv, this.sessionContext.getUserClassloader());
        return this.createStreamTableEnvironment(streamExecEnv, settings, tableConfig, executor, this.sessionContext.getSessionState().catalogManager, this.sessionContext.getSessionState().moduleManager, resourceManager, this.sessionContext.getSessionState().functionCatalog.copy(resourceManager));
    }

    private static Executor lookupExecutor(StreamExecutionEnvironment executionEnvironment, ClassLoader userClassLoader) {
        try {
            ExecutorFactory executorFactory = (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)userClassLoader, ExecutorFactory.class, (String)"default");
            Method createMethod = executorFactory.getClass().getMethod("create", StreamExecutionEnvironment.class);
            return (Executor)createMethod.invoke((Object)executorFactory, executionEnvironment);
        }
        catch (Exception e) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", (Throwable)e);
        }
    }

    private TableEnvironmentInternal createStreamTableEnvironment(StreamExecutionEnvironment env, EnvironmentSettings settings, TableConfig tableConfig, Executor executor, CatalogManager catalogManager, ModuleManager moduleManager, ResourceManager resourceManager, FunctionCatalog functionCatalog) {
        Planner planner = PlannerFactoryUtil.createPlanner((Executor)executor, (TableConfig)tableConfig, (ClassLoader)resourceManager.getUserClassLoader(), (ModuleManager)moduleManager, (CatalogManager)catalogManager, (FunctionCatalog)functionCatalog);
        return new StreamTableEnvironmentImpl(catalogManager, moduleManager, resourceManager, functionCatalog, tableConfig, env, planner, executor, settings.isStreamingMode());
    }

    private ResultFetcher executeOperationInStatementSetState(TableEnvironmentInternal tableEnv, OperationHandle handle, Operation operation) {
        if (operation instanceof EndStatementSetOperation) {
            return this.callEndStatementSetOperation(tableEnv, handle);
        }
        if (operation instanceof ModifyOperation) {
            this.sessionContext.addStatementSetOperation((ModifyOperation)operation);
            return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
        }
        throw new SqlExecutionException("Only 'INSERT/CREATE TABLE AS' statement is allowed in Statement Set or use 'END' statement to submit Statement Set.");
    }

    private ResultFetcher executeOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, Operation op, String statement, CachedPlan cachedPlan) {
        if (op instanceof SetOperation) {
            return this.callSetOperation(tableEnv, handle, (SetOperation)op);
        }
        if (op instanceof ResetOperation) {
            return this.callResetOperation(handle, (ResetOperation)op);
        }
        if (op instanceof BeginStatementSetOperation) {
            return this.callBeginStatementSetOperation(handle);
        }
        if (op instanceof EndStatementSetOperation) {
            throw new SqlExecutionException("No Statement Set to submit. 'END' statement should be used after 'BEGIN STATEMENT SET'.");
        }
        if (op instanceof ModifyOperation) {
            return this.callModifyOperations(tableEnv, handle, Collections.singletonList((ModifyOperation)op));
        }
        if (op instanceof CompileAndExecutePlanOperation || op instanceof ExecutePlanOperation) {
            return this.callExecuteOperation(tableEnv, handle, op);
        }
        if (op instanceof StatementSetOperation) {
            return this.callModifyOperations(tableEnv, handle, ((StatementSetOperation)op).getOperations());
        }
        if (op instanceof QueryOperation) {
            TableResultInternal result = cachedPlan != null ? tableEnv.executeCachedPlanInternal(cachedPlan) : tableEnv.executeInternal(op);
            PlanCacheManager planCacheManager = this.sessionContext.getPlanCacheManager();
            if (cachedPlan == null && planCacheManager != null && result.getCachedPlan() != null) {
                planCacheManager.putPlan(statement, result.getCachedPlan());
            }
            return ResultFetcher.fromTableResult(handle, result, true);
        }
        if (op instanceof StopJobOperation) {
            return this.callStopJobOperation(tableEnv, handle, (StopJobOperation)op);
        }
        if (op instanceof ShowJobsOperation) {
            return this.callShowJobsOperation(tableEnv, handle, (ShowJobsOperation)op);
        }
        if (op instanceof RemoveJarOperation) {
            return this.callRemoveJar(handle, ((RemoveJarOperation)op).getPath());
        }
        if (op instanceof AddJarOperation || op instanceof ShowJarsOperation || op instanceof CreateTempSystemFunctionOperation || op instanceof CreateCatalogFunctionOperation || op instanceof ShowFunctionsOperation) {
            return this.callExecutableOperation(handle, (ExecutableOperation)op);
        }
        return this.callOperation(tableEnv, handle, op);
    }

    private ResultFetcher callExecutableOperation(OperationHandle handle, ExecutableOperation op) {
        TableResultInternal result = op.execute((ExecutableOperation.Context)new ExecutableOperationContextImpl(this.sessionContext.getSessionState().catalogManager, this.sessionContext.getSessionState().functionCatalog, this.sessionContext.getSessionState().moduleManager, this.sessionContext.getSessionState().resourceManager, this.tableConfig(), this.sessionContext.getSessionConf().get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING));
        return ResultFetcher.fromTableResult(handle, result, false);
    }

    private TableConfig tableConfig() {
        Configuration operationConfig = this.sessionContext.getSessionConf().clone();
        operationConfig.addAll(this.executionConfig);
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setRootConfiguration((ReadableConfig)this.sessionContext.getDefaultContext().getFlinkConfig());
        tableConfig.addConfiguration(operationConfig);
        return tableConfig;
    }

    private ResultFetcher callSetOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, SetOperation setOp) {
        if (setOp.getKey().isPresent() && setOp.getValue().isPresent()) {
            this.sessionContext.set(((String)setOp.getKey().get()).trim(), ((String)setOp.getValue().get()).trim());
            return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
        }
        if (!setOp.getKey().isPresent() && !setOp.getValue().isPresent()) {
            Map configMap = tableEnv.getConfig().getConfiguration().toMap();
            return ResultFetcher.fromResults(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"key", (DataType)DataTypes.STRING()), Column.physical((String)"value", (DataType)DataTypes.STRING())}), CollectionUtil.iteratorToList(configMap.keySet().stream().sorted().map(key -> GenericRowData.of((Object[])new Object[]{StringData.fromString((String)key), StringData.fromString((String)((String)configMap.get(key)))})).map(RowData.class::cast).iterator()));
        }
        throw new SqlExecutionException("Illegal SetOperation: " + setOp.asSummaryString());
    }

    private ResultFetcher callResetOperation(OperationHandle handle, ResetOperation resetOp) {
        if (resetOp.getKey().isPresent()) {
            this.sessionContext.reset(((String)resetOp.getKey().get()).trim());
        } else {
            this.sessionContext.reset();
        }
        return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
    }

    private ResultFetcher callBeginStatementSetOperation(OperationHandle handle) {
        this.sessionContext.enableStatementSet();
        return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
    }

    private ResultFetcher callEndStatementSetOperation(TableEnvironmentInternal tableEnv, OperationHandle handle) {
        List<ModifyOperation> statementSetOperations = this.sessionContext.getStatementSetOperations();
        this.sessionContext.disableStatementSet();
        if (statementSetOperations.isEmpty()) {
            return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
        }
        return this.callModifyOperations(tableEnv, handle, statementSetOperations);
    }

    private ResultFetcher callModifyOperations(TableEnvironmentInternal tableEnv, OperationHandle handle, List<ModifyOperation> modifyOperations) {
        TableResultInternal result = tableEnv.executeInternal(modifyOperations);
        if (modifyOperations.size() == 1 && modifyOperations.get(0) instanceof DeleteFromFilterOperation) {
            return ResultFetcher.fromTableResult(handle, result, false);
        }
        return this.fetchJobId(result, handle);
    }

    private ResultFetcher callExecuteOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, Operation executePlanOperation) {
        return this.fetchJobId(tableEnv.executeInternal(executePlanOperation), handle);
    }

    private ResultFetcher fetchJobId(TableResultInternal result, OperationHandle handle) {
        JobID jobID = ((JobClient)result.getJobClient().orElseThrow(() -> new SqlExecutionException(String.format("Can't get job client for the operation %s.", handle)))).getJobID();
        return ResultFetcher.fromResults(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"job id", (DataType)DataTypes.STRING())}), Collections.singletonList(GenericRowData.of((Object[])new Object[]{StringData.fromString((String)jobID.toString())})), jobID, result.getResultKind());
    }

    protected ResultFetcher callRemoveJar(OperationHandle operationHandle, String jarPath) {
        throw new UnsupportedOperationException("SQL Gateway doesn't support REMOVE JAR syntax now.");
    }

    private ResultFetcher callOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, Operation op) {
        TableResultInternal result = tableEnv.executeInternal(op);
        return ResultFetcher.fromTableResult(handle, result, false);
    }

    private Set<TableInfo> listTables(String catalogName, String databaseName, boolean includeViews) {
        CatalogManager catalogManager = this.sessionContext.getSessionState().catalogManager;
        HashMap views = new HashMap();
        catalogManager.listViews(catalogName, databaseName).forEach(name -> views.put(name, new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.VIEW)));
        HashMap ans = new HashMap();
        if (includeViews) {
            ans.putAll(views);
        }
        catalogManager.listTables(catalogName, databaseName).stream().filter(name -> !views.containsKey(name)).forEach(name -> ans.put(name, new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.TABLE)));
        return Collections.unmodifiableSet(new HashSet(ans.values()));
    }

    private Set<TableInfo> listViews(String catalogName, String databaseName) {
        return Collections.unmodifiableSet(this.sessionContext.getSessionState().catalogManager.listViews(catalogName, databaseName).stream().map(name -> new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.VIEW)).collect(Collectors.toSet()));
    }

    public ResultFetcher callStopJobOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, StopJobOperation stopJobOperation) throws SqlExecutionException {
        String jobId = stopJobOperation.getJobId();
        boolean isWithSavepoint = stopJobOperation.isWithSavepoint();
        boolean isWithDrain = stopJobOperation.isWithDrain();
        Configuration configuration = tableEnv.getConfig().getConfiguration();
        Duration clientTimeout = (Duration)configuration.get(ClientOptions.CLIENT_TIMEOUT);
        Optional savepoint = this.runClusterAction(configuration, handle, clusterClient -> {
            try {
                if (isWithSavepoint) {
                    return Optional.of(clusterClient.stopWithSavepoint(JobID.fromHexString((String)jobId), isWithDrain, (String)configuration.get(CheckpointingOptions.SAVEPOINT_DIRECTORY), SavepointFormatType.DEFAULT).get(clientTimeout.toMillis(), TimeUnit.MILLISECONDS));
                }
                clusterClient.cancel(JobID.fromHexString((String)jobId)).get(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
                return Optional.empty();
            }
            catch (Exception e) {
                throw new SqlExecutionException(String.format("Could not stop job %s %s for operation %s.", jobId, isWithSavepoint ? "with savepoint" : "", handle.getIdentifier()), e);
            }
        });
        if (isWithSavepoint) {
            return ResultFetcher.fromResults(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"savepoint path", (DataType)DataTypes.STRING())}), Collections.singletonList(GenericRowData.of((Object[])new Object[]{StringData.fromString((String)savepoint.orElse(""))})));
        }
        return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
    }

    public ResultFetcher callShowJobsOperation(TableEnvironmentInternal tableEnv, OperationHandle operationHandle, ShowJobsOperation showJobsOperation) throws SqlExecutionException {
        Configuration configuration = tableEnv.getConfig().getConfiguration();
        Duration clientTimeout = (Duration)configuration.get(ClientOptions.CLIENT_TIMEOUT);
        Collection jobs = this.runClusterAction(configuration, operationHandle, clusterClient -> {
            try {
                return (Collection)clusterClient.listJobs().get(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new SqlExecutionException("Failed to list jobs in the cluster.", e);
            }
        });
        List<RowData> resultRows = jobs.stream().map(job -> GenericRowData.of((Object[])new Object[]{StringData.fromString((String)job.getJobId().toString()), StringData.fromString((String)job.getJobName()), StringData.fromString((String)job.getJobState().toString()), DateTimeUtils.toTimestampData((long)job.getStartTime(), (int)3)})).collect(Collectors.toList());
        return ResultFetcher.fromResults(operationHandle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"job id", (DataType)DataTypes.STRING()), Column.physical((String)"job name", (DataType)DataTypes.STRING()), Column.physical((String)"status", (DataType)DataTypes.STRING()), Column.physical((String)"start time", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE())}), resultRows);
    }

    /*
     * Exception decompiling
     */
    private <ClusterID, Result> Result runClusterAction(Configuration configuration, OperationHandle handle, ClusterAction<ClusterID, Result> clusterAction) throws SqlExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    private static interface ClusterAction<ClusterID, Result> {
        public Result runAction(ClusterClient<ClusterID> var1) throws FlinkException;
    }
}

