/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.typeutils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.ArrayType;
import org.apache.flink.cdc.common.types.BinaryType;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.MapType;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.common.types.VarBinaryType;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.shaded.guava31.com.google.common.io.BaseEncoding;

public class BinaryRecordDataExtractor {
    @CheckReturnValue
    public static Object extractRecord(RecordData record, Schema schema) {
        return BinaryRecordDataExtractor.extractRecord((Object)record, schema.toRowDataType());
    }

    @CheckReturnValue
    public static Object extractRecord(Object object, DataType dataType) {
        if (object == null) {
            return "null";
        }
        if (dataType instanceof BinaryType || dataType instanceof VarBinaryType) {
            Preconditions.checkArgument(object instanceof byte[], "Column data of BinaryType and VarBinaryType should be `byte[]`, but was %s", object.getClass().getName());
            return BaseEncoding.base64().encode((byte[])object);
        }
        if (dataType instanceof MapType) {
            Preconditions.checkArgument(object instanceof MapData, "Column data of MapType should be MapData, but was %s", object.getClass().getName());
            MapType mapType = (MapType)dataType;
            MapData mapData = (MapData)object;
            List keyArray = (List)BinaryRecordDataExtractor.extractRecord(mapData.keyArray(), DataTypes.ARRAY(mapType.getKeyType()));
            List valueArray = (List)BinaryRecordDataExtractor.extractRecord(mapData.valueArray(), DataTypes.ARRAY(mapType.getValueType()));
            Preconditions.checkArgument(keyArray.size() == valueArray.size(), "Malformed MapData: keyArray size (%d) differs from valueArray (%d)", keyArray.size(), valueArray.size());
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < keyArray.size(); ++i) {
                sb.append(keyArray.get(i)).append(" -> ").append(valueArray.get(i)).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            return sb.append("}").toString();
        }
        if (dataType instanceof ArrayType) {
            Preconditions.checkArgument(object instanceof ArrayData, "Column data of ArrayType should be ArrayData, but was %s", object.getClass().getName());
            ArrayType arrayType = (ArrayType)dataType;
            ArrayData arrayData = (ArrayData)object;
            ArrayData.ElementGetter getter = ArrayData.createElementGetter(arrayType.getElementType());
            ArrayList<Object> results = new ArrayList<Object>();
            for (int i = 0; i < arrayData.size(); ++i) {
                results.add(getter.getElementOrNull(arrayData, i));
            }
            return results;
        }
        if (dataType instanceof RowType) {
            Preconditions.checkArgument(object instanceof RecordData, "Column data of RowType should be RecordData, but was %s", object.getClass().getName());
            RowType rowType = (RowType)dataType;
            RecordData binaryRecordData = (RecordData)object;
            List<String> fieldNames = rowType.getFieldNames();
            List<DataType> fieldTypes = rowType.getFieldTypes();
            List<RecordData.FieldGetter> fieldGetters = SchemaUtils.createFieldGetters(fieldTypes.toArray(new DataType[0]));
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                sb.append(fieldNames.get(i)).append(": ").append(fieldTypes.get(i)).append(" -> ").append(BinaryRecordDataExtractor.extractRecord(fieldGetters.get(i).getFieldOrNull(binaryRecordData), fieldTypes.get(i))).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            return sb.append("}").toString();
        }
        return object.toString();
    }
}

