/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformChangeInfo;
import org.apache.flink.cdc.runtime.operators.transform.TransformContext;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionCompiler;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionKey;
import org.apache.flink.cdc.runtime.operators.transform.TransformFilter;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.parser.JaninoCompiler;
import org.apache.flink.cdc.runtime.parser.metadata.MetadataColumns;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.codehaus.janino.ExpressionEvaluator;

public class TransformFilterProcessor {
    private final boolean isNoOp;
    private final PostTransformChangeInfo tableInfo;
    private final TransformFilter transformFilter;
    private final String timezone;
    private final List<Object> udfFunctionInstances;
    private final Map<String, SupportedMetadataColumn> supportedMetadataColumns;
    private final TransformExpressionKey transformExpressionKey;
    private final ExpressionEvaluator expressionEvaluator;

    protected TransformFilterProcessor(boolean isNoOp, PostTransformChangeInfo tableInfo, TransformFilter transformFilter, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, Map<String, SupportedMetadataColumn> supportedMetadataColumns) {
        this.isNoOp = isNoOp;
        this.tableInfo = tableInfo;
        this.transformFilter = transformFilter;
        this.timezone = timezone;
        this.udfFunctionInstances = udfFunctionInstances;
        this.supportedMetadataColumns = supportedMetadataColumns;
        if (isNoOp) {
            this.transformExpressionKey = null;
            this.expressionEvaluator = null;
        } else {
            this.transformExpressionKey = this.generateTransformExpressionKey();
            this.expressionEvaluator = TransformExpressionCompiler.compileExpression(this.transformExpressionKey, udfDescriptors);
        }
    }

    public static TransformFilterProcessor ofNoOp() {
        return new TransformFilterProcessor(true, null, null, null, null, null, null);
    }

    public static TransformFilterProcessor of(PostTransformChangeInfo tableInfo, TransformFilter transformFilter, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, SupportedMetadataColumn[] supportedMetadataColumns) {
        HashMap<String, SupportedMetadataColumn> supportedMetadataColumnsMap = new HashMap<String, SupportedMetadataColumn>();
        for (SupportedMetadataColumn supportedMetadataColumn : supportedMetadataColumns) {
            supportedMetadataColumnsMap.put(supportedMetadataColumn.getName(), supportedMetadataColumn);
        }
        return new TransformFilterProcessor(false, tableInfo, transformFilter, timezone, udfDescriptors, udfFunctionInstances, supportedMetadataColumnsMap);
    }

    public boolean test(Object[] preRow, Object[] postRow, TransformContext context) {
        if (this.isNoOp) {
            return true;
        }
        try {
            return (Boolean)this.expressionEvaluator.evaluate(this.generateParams(preRow, postRow, context));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("Failed to evaluate filtering expression `%s` for table `%s`.\n\tColumn name map: {%s}", this.transformFilter.getScriptExpression(), this.tableInfo.getName(), this.transformFilter.getColumnNameMapAsString()), e);
        }
    }

    private Tuple2<List<String>, List<Class<?>>> generateArguments(boolean mapColumnNames) {
        ArrayList<String> rawArgNames = new ArrayList<String>();
        ArrayList<String> argNames = new ArrayList<String>();
        ArrayList argTypes = new ArrayList();
        String expression = this.transformFilter.getExpression();
        ArrayList<Column> columns = new ArrayList<Column>(this.tableInfo.getPostTransformedSchema().getColumns());
        HashSet<String> existingColumnNames = new HashSet<String>(this.tableInfo.getPostTransformedSchema().getColumnNames());
        this.tableInfo.getPreTransformedSchema().getColumns().stream().filter(col -> !existingColumnNames.contains(col.getName())).forEach(columns::add);
        Map<String, String> columnNameMap = this.transformFilter.getColumnNameMap();
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>(this.transformFilter.getColumnNames());
        block0: for (String columnName : columnNames) {
            for (Column column : columns) {
                if (!column.getName().equals(columnName)) continue;
                rawArgNames.add(columnName);
                argNames.add(mapColumnNames ? columnNameMap.get(columnName) : columnName);
                argTypes.add(DataTypeConverter.convertOriginalClass(column.getType()));
                continue block0;
            }
        }
        MetadataColumns.METADATA_COLUMNS.forEach(col -> {
            if (expression.contains((CharSequence)col.f0) && !rawArgNames.contains(col.f0)) {
                rawArgNames.add((String)col.f0);
                argNames.add(mapColumnNames ? (String)columnNameMap.get(col.f0) : (String)col.f0);
                argTypes.add((Class<?>)col.f2);
            }
        });
        this.supportedMetadataColumns.keySet().forEach(colName -> {
            if (expression.contains((CharSequence)colName) && !rawArgNames.contains(colName)) {
                rawArgNames.add((String)colName);
                argNames.add(mapColumnNames ? (String)columnNameMap.get(colName) : colName);
                argTypes.add(this.supportedMetadataColumns.get(colName).getJavaClass());
            }
        });
        return Tuple2.of(argNames, argTypes);
    }

    private Object[] generateParams(Object[] preRow, Object[] postRow, TransformContext context) {
        ArrayList<Object> params = new ArrayList<Object>();
        Tuple2<List<String>, List<Class<?>>> args = this.generateArguments(false);
        for (String columnName : (List)args.f0) {
            params.add(TransformContext.lookupObjectByName(columnName, this.tableInfo, this.supportedMetadataColumns, preRow, postRow, context));
        }
        params.add(this.timezone);
        params.add(context.epochTime);
        params.addAll(this.udfFunctionInstances);
        return params.toArray();
    }

    private TransformExpressionKey generateTransformExpressionKey() {
        Tuple2<List<String>, List<Class<?>>> args = this.generateArguments(true);
        ((List)args.f0).add("__time_zone__");
        ((List)args.f1).add(String.class);
        ((List)args.f0).add("__epoch_time__");
        ((List)args.f1).add(Long.class);
        return TransformExpressionKey.of(JaninoCompiler.loadSystemFunction(this.transformFilter.getScriptExpression()), (List)args.f0, (List)args.f1, Boolean.class, this.transformFilter.getColumnNameMap());
    }
}

