/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformChangeInfo;

public class TransformContext {
    public long epochTime;
    public String opType;
    public Map<String, String> meta;

    public static Object lookupObjectByName(String name, PostTransformChangeInfo tableInfo, Map<String, SupportedMetadataColumn> supportedMetadataColumns, Object[] preRow, @Nullable Object[] postRow, TransformContext context) {
        Integer indexInPostTransformedSchema;
        switch (name) {
            case "__namespace_name__": {
                return tableInfo.getNamespace();
            }
            case "__schema_name__": {
                return tableInfo.getSchemaName();
            }
            case "__table_name__": {
                return tableInfo.getTableName();
            }
            case "__data_event_type__": {
                return context.opType;
            }
        }
        if (supportedMetadataColumns.containsKey(name)) {
            return supportedMetadataColumns.get(name).read(context.meta);
        }
        if (postRow != null && (indexInPostTransformedSchema = tableInfo.getPostTransformedSchemaFieldIndex(name)) != null) {
            return postRow[indexInPostTransformedSchema];
        }
        Integer indexInPreTransformedSchema = tableInfo.getPreTransformedSchemaFieldIndex(name);
        if (indexInPreTransformedSchema != null) {
            return preRow[indexInPreTransformedSchema];
        }
        throw new RuntimeException("Failed to lookup column name: " + name);
    }
}

