/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.data;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.data.LocalZonedTimestampData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class LocalZonedTimestampDataSerializer
extends TypeSerializer<LocalZonedTimestampData> {
    private static final long serialVersionUID = 1L;
    private final int precision;

    public LocalZonedTimestampDataSerializer(int precision) {
        this.precision = precision;
    }

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<LocalZonedTimestampData> duplicate() {
        return new LocalZonedTimestampDataSerializer(this.precision);
    }

    public LocalZonedTimestampData createInstance() {
        return LocalZonedTimestampData.fromEpochMillis(0L, 0);
    }

    public LocalZonedTimestampData copy(LocalZonedTimestampData from) {
        return LocalZonedTimestampData.fromEpochMillis(from.getEpochMillisecond(), from.getEpochNanoOfMillisecond());
    }

    public LocalZonedTimestampData copy(LocalZonedTimestampData from, LocalZonedTimestampData reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return LocalZonedTimestampData.isCompact(this.precision) ? 8 : 12;
    }

    public void serialize(LocalZonedTimestampData record, DataOutputView target) throws IOException {
        if (LocalZonedTimestampData.isCompact(this.precision)) {
            assert (record.getEpochNanoOfMillisecond() == 0);
            target.writeLong(record.getEpochMillisecond());
        } else {
            target.writeLong(record.getEpochMillisecond());
            target.writeInt(record.getEpochNanoOfMillisecond());
        }
    }

    public LocalZonedTimestampData deserialize(DataInputView source) throws IOException {
        if (TimestampData.isCompact(this.precision)) {
            long val = source.readLong();
            return LocalZonedTimestampData.fromEpochMillis(val, 0);
        }
        long longVal = source.readLong();
        int intVal = source.readInt();
        return LocalZonedTimestampData.fromEpochMillis(longVal, intVal);
    }

    public LocalZonedTimestampData deserialize(LocalZonedTimestampData reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (LocalZonedTimestampData.isCompact(this.precision)) {
            target.writeLong(source.readLong());
        } else {
            target.writeLong(source.readLong());
            target.writeInt(source.readInt());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LocalZonedTimestampDataSerializer that = (LocalZonedTimestampDataSerializer)((Object)obj);
        return this.precision == that.precision;
    }

    public int hashCode() {
        return this.precision;
    }

    public TypeSerializerSnapshot<LocalZonedTimestampData> snapshotConfiguration() {
        return new LocalZonedTimestampDataSerializerSnapshot(this.precision);
    }

    public static final class LocalZonedTimestampDataSerializerSnapshot
    implements TypeSerializerSnapshot<LocalZonedTimestampData> {
        private static final int CURRENT_VERSION = 1;
        private int previousPrecision;

        public LocalZonedTimestampDataSerializerSnapshot() {
        }

        LocalZonedTimestampDataSerializerSnapshot(int precision) {
            this.previousPrecision = precision;
        }

        public int getCurrentVersion() {
            return 1;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousPrecision);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.previousPrecision = in.readInt();
        }

        public TypeSerializer<LocalZonedTimestampData> restoreSerializer() {
            return new LocalZonedTimestampDataSerializer(this.previousPrecision);
        }

        public TypeSerializerSchemaCompatibility<LocalZonedTimestampData> resolveSchemaCompatibility(TypeSerializer<LocalZonedTimestampData> newSerializer) {
            if (!(newSerializer instanceof LocalZonedTimestampDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            LocalZonedTimestampDataSerializer timestampDataSerializer = (LocalZonedTimestampDataSerializer)newSerializer;
            if (this.previousPrecision != timestampDataSerializer.precision) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

