/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.grpc;

import io.vitess.client.Context;
import io.vitess.client.Proto;
import io.vitess.client.RpcClient;
import io.vitess.client.StreamIterator;
import io.vitess.client.grpc.GrpcStreamAdapter;
import io.vitess.proto.Query;
import io.vitess.proto.Vtgate;
import io.vitess.proto.grpc.VitessGrpc;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.util.concurrent.AsyncFunction;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.util.concurrent.Futures;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.CallCredentials;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.InternalWithLogId;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ManagedChannel;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.StatusRuntimeException;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.stub.StreamObserver;
import org.joda.time.Duration;

public class GrpcClient
implements RpcClient {
    private static final Duration DEFAULT_TIMEOUT = Duration.standardSeconds(30L);
    private final ManagedChannel channel;
    private final String channelId;
    private final VitessGrpc.VitessStub asyncStub;
    private final VitessGrpc.VitessFutureStub futureStub;
    private final Duration timeout;

    public GrpcClient(ManagedChannel channel) {
        this.channel = channel;
        this.channelId = this.toChannelId(channel);
        this.asyncStub = VitessGrpc.newStub(channel);
        this.futureStub = VitessGrpc.newFutureStub(channel);
        this.timeout = DEFAULT_TIMEOUT;
    }

    public GrpcClient(ManagedChannel channel, Context context) {
        this.channel = channel;
        this.channelId = this.toChannelId(channel);
        this.asyncStub = VitessGrpc.newStub(channel);
        this.futureStub = VitessGrpc.newFutureStub(channel);
        this.timeout = GrpcClient.getContextTimeoutOrDefault(context);
    }

    public GrpcClient(ManagedChannel channel, CallCredentials credentials, Context context) {
        this.channel = channel;
        this.channelId = this.toChannelId(channel);
        this.asyncStub = (VitessGrpc.VitessStub)VitessGrpc.newStub(channel).withCallCredentials(credentials);
        this.futureStub = (VitessGrpc.VitessFutureStub)VitessGrpc.newFutureStub(channel).withCallCredentials(credentials);
        this.timeout = GrpcClient.getContextTimeoutOrDefault(context);
    }

    private String toChannelId(ManagedChannel channel) {
        return channel instanceof InternalWithLogId ? ((InternalWithLogId)((Object)channel)).getLogId().toString() : channel.toString();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.channel.shutdown().awaitTermination(this.timeout.getStandardSeconds(), TimeUnit.SECONDS)) {
                this.channel.shutdownNow();
            }
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public ListenableFuture<Vtgate.ExecuteResponse> execute(Context ctx, Vtgate.ExecuteRequest request) throws SQLException {
        return Futures.catchingAsync(this.getFutureStub(ctx).execute(request), Exception.class, new ExceptionConverter(), MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<Vtgate.ExecuteBatchResponse> executeBatch(Context ctx, Vtgate.ExecuteBatchRequest request) throws SQLException {
        return Futures.catchingAsync(this.getFutureStub(ctx).executeBatch(request), Exception.class, new ExceptionConverter(), MoreExecutors.directExecutor());
    }

    @Override
    public StreamIterator<Query.QueryResult> streamExecute(Context ctx, Vtgate.StreamExecuteRequest request) throws SQLException {
        GrpcStreamAdapter<Vtgate.StreamExecuteResponse, Query.QueryResult> adapter = new GrpcStreamAdapter<Vtgate.StreamExecuteResponse, Query.QueryResult>(){

            @Override
            Query.QueryResult getResult(Vtgate.StreamExecuteResponse response) throws SQLException {
                return response.getResult();
            }
        };
        this.getAsyncStub(ctx).streamExecute(request, (StreamObserver<Vtgate.StreamExecuteResponse>)adapter);
        return adapter;
    }

    @Override
    public StreamIterator<Vtgate.VStreamResponse> getVStream(Context ctx, Vtgate.VStreamRequest vstreamRequest) {
        GrpcStreamAdapter<Vtgate.VStreamResponse, Vtgate.VStreamResponse> adapter = new GrpcStreamAdapter<Vtgate.VStreamResponse, Vtgate.VStreamResponse>(){

            @Override
            Vtgate.VStreamResponse getResult(Vtgate.VStreamResponse response) {
                return response;
            }
        };
        this.getAsyncStub(ctx).vStream(vstreamRequest, (StreamObserver<Vtgate.VStreamResponse>)adapter);
        return adapter;
    }

    static SQLException convertGrpcError(Throwable exc) {
        if (exc instanceof StatusRuntimeException) {
            StatusRuntimeException sre = (StatusRuntimeException)exc;
            int errno = Proto.getErrno(sre.getMessage());
            String sqlState = Proto.getSQLState(sre.getMessage());
            switch (sre.getStatus().getCode()) {
                case INVALID_ARGUMENT: {
                    return new SQLSyntaxErrorException(sre.toString(), sqlState, errno, sre);
                }
                case DEADLINE_EXCEEDED: {
                    return new SQLTimeoutException(sre.toString(), sqlState, errno, sre);
                }
                case ALREADY_EXISTS: {
                    return new SQLIntegrityConstraintViolationException(sre.toString(), sqlState, errno, sre);
                }
                case UNAUTHENTICATED: {
                    return new SQLInvalidAuthorizationSpecException(sre.toString(), sqlState, errno, sre);
                }
                case UNAVAILABLE: {
                    return new SQLTransientException(sre.toString(), sqlState, errno, sre);
                }
                case ABORTED: {
                    return new SQLRecoverableException(sre.toString(), sqlState, errno, sre);
                }
            }
            String advice = "";
            if (exc.getCause() instanceof ClosedChannelException) {
                advice = "Failed to connect to vtgate. Make sure that vtgate is running and you are using the correct address. Details: ";
            }
            return new SQLNonTransientException("gRPC StatusRuntimeException: " + advice + exc.toString(), sqlState, errno, exc);
        }
        return new SQLNonTransientException("gRPC error: " + exc.toString(), exc);
    }

    private VitessGrpc.VitessStub getAsyncStub(Context ctx) {
        Duration timeout = ctx.getTimeout();
        if (timeout == null) {
            return this.asyncStub;
        }
        return (VitessGrpc.VitessStub)this.asyncStub.withDeadlineAfter(timeout.getMillis(), TimeUnit.MILLISECONDS);
    }

    private VitessGrpc.VitessFutureStub getFutureStub(Context ctx) {
        Duration timeout = ctx.getTimeout();
        if (timeout == null) {
            return this.futureStub;
        }
        return (VitessGrpc.VitessFutureStub)this.futureStub.withDeadlineAfter(timeout.getMillis(), TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return String.format("[GrpcClient-%s channel=%s]", Integer.toHexString(this.hashCode()), this.channelId);
    }

    private static Duration getContextTimeoutOrDefault(Context context) {
        if (context.getTimeout() == null || context.getTimeout().getStandardSeconds() < 0L) {
            return DEFAULT_TIMEOUT;
        }
        return context.getTimeout();
    }

    static class ExceptionConverter<V>
    implements AsyncFunction<Exception, V> {
        ExceptionConverter() {
        }

        @Override
        public ListenableFuture<V> apply(Exception exc) throws Exception {
            throw GrpcClient.convertGrpcError(exc);
        }
    }
}

