/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.cursor;

import io.vitess.proto.Query;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.Preconditions;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableList;

public class FieldMap {
    private final List<Query.Field> fields;
    private final Map<String, Integer> labelMap;
    private final Map<String, Integer> nameMap;
    private final Map<String, Integer> fullNameMap;

    public FieldMap(Iterable<Query.Field> fields) {
        this.fields = ImmutableList.copyOf(Preconditions.checkNotNull(fields));
        this.labelMap = new CaseInsensitiveMap<String, Integer>();
        this.nameMap = new CaseInsensitiveMap<String, Integer>();
        this.fullNameMap = new CaseInsensitiveMap<String, Integer>();
        int columnIndex = 1;
        for (Query.Field field : this.fields) {
            String tableName;
            String origName;
            String columnLabel = field.getName();
            if (!this.labelMap.containsKey(columnLabel)) {
                this.labelMap.put(columnLabel, columnIndex);
            }
            if (!"".equals(origName = field.getOrgName()) && !this.nameMap.containsKey(origName)) {
                this.nameMap.put(origName, columnIndex);
            }
            if (!"".equals(tableName = field.getTable())) {
                StringBuilder fullNameBuf = new StringBuilder();
                fullNameBuf.append(tableName);
                fullNameBuf.append('.');
                fullNameBuf.append(field.getName());
                String fullName = fullNameBuf.toString();
                if (!this.fullNameMap.containsKey(fullName)) {
                    this.fullNameMap.put(fullName, columnIndex);
                }
            }
            ++columnIndex;
        }
    }

    public List<Query.Field> getList() {
        return this.fields;
    }

    public Query.Field get(int columnIndex) {
        Preconditions.checkArgument(columnIndex >= 1, "columnIndex out of range: %s", columnIndex);
        return this.fields.get(columnIndex - 1);
    }

    @Nullable
    public Integer getIndex(String columnLabel) {
        Integer index = this.labelMap.get(columnLabel);
        if (index == null) {
            index = this.nameMap.get(columnLabel);
        }
        if (index == null) {
            index = this.fullNameMap.get(columnLabel);
        }
        return index;
    }
}

