/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.connector.vitess.SourceInfo;
import io.debezium.connector.vitess.Vgtid;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.connection.VitessReplicationConnection;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessOffsetContext
implements OffsetContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessOffsetContext.class);
    private final Schema sourceInfoSchema;
    private final SourceInfo sourceInfo;
    private final TransactionContext transactionContext;

    public VitessOffsetContext(VitessConnectorConfig connectorConfig, Vgtid initialVgtid, Instant time, TransactionContext transactionContext) {
        this.sourceInfo = new SourceInfo(connectorConfig);
        this.sourceInfo.resetVgtid(initialVgtid, time);
        this.sourceInfoSchema = this.sourceInfo.schema();
        this.transactionContext = transactionContext;
    }

    public static VitessOffsetContext initialContext(VitessConnectorConfig connectorConfig, Clock clock) {
        LOGGER.info("No previous offset exists. Use default VGTID.");
        Vgtid defaultVgtid = VitessReplicationConnection.defaultVgtid(connectorConfig);
        return new VitessOffsetContext(connectorConfig, defaultVgtid, clock.currentTimeAsInstant(), new TransactionContext());
    }

    public void rotateVgtid(Vgtid newVgtid, Instant commitTime) {
        this.sourceInfo.rotateVgtid(newVgtid, commitTime);
    }

    public void resetVgtid(Vgtid newVgtid, Instant commitTime) {
        this.sourceInfo.resetVgtid(newVgtid, commitTime);
    }

    public Vgtid getRestartVgtid() {
        return this.sourceInfo.getRestartVgtid();
    }

    @Override
    public Map<String, ?> getOffset() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.sourceInfo.getRestartVgtid() != null) {
            result.put("vgtid", this.sourceInfo.getRestartVgtid().toString());
        }
        return this.transactionContext.store(result);
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    @Override
    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    @Override
    public boolean isSnapshotRunning() {
        return false;
    }

    @Override
    public void markLastSnapshotRecord() {
    }

    @Override
    public void preSnapshotStart() {
    }

    @Override
    public void preSnapshotCompletion() {
    }

    @Override
    public void postSnapshotCompletion() {
    }

    @Override
    public void event(DataCollectionId collectionId, Instant timestamp) {
        this.sourceInfo.setTimestamp(timestamp);
        this.sourceInfo.setTableId((TableId)collectionId);
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public String toString() {
        return "VitessOffsetContext{sourceInfo=" + this.sourceInfo + '}';
    }

    public static class Loader
    implements OffsetContext.Loader<VitessOffsetContext> {
        private final VitessConnectorConfig connectorConfig;

        public Loader(VitessConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        @Override
        public VitessOffsetContext load(Map<String, ?> offset) {
            String vgtid = (String)offset.get("vgtid");
            return new VitessOffsetContext(this.connectorConfig, Vgtid.of(vgtid), null, TransactionContext.load(offset));
        }
    }
}

