/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.distributed;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.pipeline.SchemaChangeBehavior;
import org.apache.flink.cdc.common.route.RouteRule;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.runtime.operators.schema.common.CoordinatorExecutorThreadFactory;
import org.apache.flink.cdc.runtime.operators.schema.distributed.SchemaCoordinator;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;

@Internal
public class SchemaCoordinatorProvider
implements OperatorCoordinator.Provider {
    private static final long serialVersionUID = 1L;
    private final OperatorID operatorID;
    private final String operatorName;
    private final MetadataApplier metadataApplier;
    private final List<RouteRule> routingRules;
    private final SchemaChangeBehavior schemaChangeBehavior;
    private final Duration rpcTimeout;

    public SchemaCoordinatorProvider(OperatorID operatorID, String operatorName, MetadataApplier metadataApplier, List<RouteRule> routingRules, SchemaChangeBehavior schemaChangeBehavior, Duration rpcTimeout) {
        this.operatorID = operatorID;
        this.operatorName = operatorName;
        this.metadataApplier = metadataApplier;
        this.routingRules = routingRules;
        this.schemaChangeBehavior = schemaChangeBehavior;
        this.rpcTimeout = rpcTimeout;
    }

    public OperatorID getOperatorId() {
        return this.operatorID;
    }

    public OperatorCoordinator create(OperatorCoordinator.Context context) throws Exception {
        CoordinatorExecutorThreadFactory coordinatorThreadFactory = new CoordinatorExecutorThreadFactory("schema-evolution-coordinator", context.getUserCodeClassloader());
        ExecutorService coordinatorExecutor = Executors.newSingleThreadExecutor(coordinatorThreadFactory);
        return new SchemaCoordinator(this.operatorName, context, coordinatorExecutor, this.metadataApplier, this.routingRules, this.schemaChangeBehavior, this.rpcTimeout);
    }
}

