/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformChangeInfo;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumnProcessor;
import org.apache.flink.cdc.runtime.operators.transform.TransformProjection;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.parser.TransformParser;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformProjectionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TransformProjectionProcessor.class);
    private final PostTransformChangeInfo postTransformChangeInfo;
    private final TransformProjection transformProjection;
    private final String timezone;
    private final List<ProjectionColumnProcessor> cachedProjectionColumnProcessors;
    private final List<UserDefinedFunctionDescriptor> udfDescriptors;
    private final transient List<Object> udfFunctionInstances;

    public TransformProjectionProcessor(PostTransformChangeInfo postTransformChangeInfo, TransformProjection transformProjection, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances) {
        this.postTransformChangeInfo = postTransformChangeInfo;
        this.transformProjection = transformProjection;
        this.timezone = timezone;
        this.udfDescriptors = udfDescriptors;
        this.udfFunctionInstances = udfFunctionInstances;
        this.cachedProjectionColumnProcessors = this.cacheProjectionColumnProcessors(postTransformChangeInfo, transformProjection);
    }

    public boolean hasTableInfo() {
        return this.postTransformChangeInfo != null;
    }

    public static TransformProjectionProcessor of(PostTransformChangeInfo tableInfo, TransformProjection transformProjection, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances) {
        return new TransformProjectionProcessor(tableInfo, transformProjection, timezone, udfDescriptors, udfFunctionInstances);
    }

    public static TransformProjectionProcessor of(TransformProjection transformProjection, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances) {
        return new TransformProjectionProcessor(null, transformProjection, timezone, udfDescriptors, udfFunctionInstances);
    }

    public static TransformProjectionProcessor of(TransformProjection transformProjection, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances) {
        return new TransformProjectionProcessor(null, transformProjection, null, udfDescriptors, udfFunctionInstances);
    }

    public Schema processSchemaChangeEvent(Schema schema) {
        List<ProjectionColumn> projectionColumns = TransformParser.generateProjectionColumns(this.transformProjection.getProjection(), schema.getColumns(), this.udfDescriptors);
        this.transformProjection.setProjectionColumns(projectionColumns);
        return schema.copy(projectionColumns.stream().map(ProjectionColumn::getColumn).collect(Collectors.toList()));
    }

    public BinaryRecordData processData(BinaryRecordData payload, long epochTime, String opType) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        List<Column> columns = this.postTransformChangeInfo.getPostTransformedSchema().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            ProjectionColumnProcessor projectionColumnProcessor = this.cachedProjectionColumnProcessors.get(i);
            if (projectionColumnProcessor != null) {
                ProjectionColumn projectionColumn = projectionColumnProcessor.getProjectionColumn();
                valueList.add(DataTypeConverter.convert(projectionColumnProcessor.evaluate(payload, epochTime, opType), projectionColumn.getDataType()));
                continue;
            }
            Column column = columns.get(i);
            valueList.add(this.getValueFromBinaryRecordData(column.getName(), column.getType(), payload, this.postTransformChangeInfo.getPreTransformedSchema().getColumns(), this.postTransformChangeInfo.getPreTransformedFieldGetters()));
        }
        return this.postTransformChangeInfo.getRecordDataGenerator().generate(valueList.toArray(new Object[0]));
    }

    private Object getValueFromBinaryRecordData(String columnName, DataType expectedType, BinaryRecordData binaryRecordData, List<Column> columns, RecordData.FieldGetter[] fieldGetters) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columnName.equals(columns.get(i).getName())) continue;
            return DataTypeConverter.convert(fieldGetters[i].getFieldOrNull(binaryRecordData), expectedType);
        }
        return null;
    }

    private List<ProjectionColumnProcessor> cacheProjectionColumnProcessors(PostTransformChangeInfo tableInfo, TransformProjection transformProjection) {
        ArrayList<ProjectionColumnProcessor> cachedProjectionColumnProcessors = new ArrayList<ProjectionColumnProcessor>();
        if (!this.hasTableInfo()) {
            return cachedProjectionColumnProcessors;
        }
        for (Column column : tableInfo.getPostTransformedSchema().getColumns()) {
            ProjectionColumn matchedProjectionColumn = null;
            for (ProjectionColumn projectionColumn : transformProjection.getProjectionColumns()) {
                if (!column.getName().equals(projectionColumn.getColumnName()) || !projectionColumn.isValidTransformedProjectionColumn()) continue;
                matchedProjectionColumn = projectionColumn;
                break;
            }
            cachedProjectionColumnProcessors.add(Optional.ofNullable(matchedProjectionColumn).map(col -> ProjectionColumnProcessor.of(tableInfo, col, this.timezone, this.udfDescriptors, this.udfFunctionInstances)).orElse(null));
        }
        return cachedProjectionColumnProcessors;
    }
}

