/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;

public class RenameColumnEvent
implements SchemaChangeEvent {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final Map<String, String> nameMapping;

    public RenameColumnEvent(TableId tableId, Map<String, String> nameMapping) {
        this.tableId = tableId;
        this.nameMapping = nameMapping;
    }

    public Map<String, String> getNameMapping() {
        return this.nameMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenameColumnEvent)) {
            return false;
        }
        RenameColumnEvent that = (RenameColumnEvent)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.nameMapping, that.nameMapping);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.nameMapping);
    }

    public String toString() {
        return "RenameColumnEvent{tableId=" + this.tableId + ", nameMapping=" + this.nameMapping + '}';
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public SchemaChangeEventType getType() {
        return SchemaChangeEventType.RENAME_COLUMN;
    }
}

