/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client;

import io.vitess.client.SQLFuture;
import io.vitess.proto.Query;
import io.vitess.proto.Vtgate;

public class VTSession {
    private Vtgate.Session session;
    private SQLFuture<?> lastCall;

    public VTSession(String target, Query.ExecuteOptions options) {
        this.session = Vtgate.Session.newBuilder().setTargetString(null == target ? "" : target).setOptions(null == options ? Query.ExecuteOptions.newBuilder().build() : options).setAutocommit(true).setInTransaction(false).build();
    }

    public Vtgate.Session getSession() {
        return this.session;
    }

    public void setSession(Vtgate.Session session) {
        this.session = session;
    }

    public boolean isAutoCommit() {
        return this.session.getAutocommit();
    }

    public void setAutoCommit(boolean autoCommit) {
        this.session = this.session.toBuilder().setAutocommit(autoCommit).build();
    }

    public boolean isInTransaction() {
        return this.session.getShardSessionsCount() > 0;
    }

    public Query.ExecuteOptions.TransactionIsolation getTransactionIsolation() {
        return this.session.getOptions().getTransactionIsolation();
    }

    public void setTransactionIsolation(Query.ExecuteOptions.TransactionIsolation isolation) {
        this.session = this.session.toBuilder().setOptions(this.session.getOptions().toBuilder().setTransactionIsolation(isolation)).build();
    }

    public void setLastCall(SQLFuture call) {
        this.lastCall = call;
    }

    public void checkCallIsAllowed(String call) throws IllegalStateException {
        if (this.lastCall != null && !this.lastCall.isDone()) {
            throw new IllegalStateException("Can't call " + call + "() until the last asynchronous call is done on this transaction.");
        }
    }
}

