/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.vitess.VitessConnector;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.pipeline.ErrorHandler;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessErrorHandler
extends ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessErrorHandler.class);

    public VitessErrorHandler(VitessConnectorConfig connectorConfig, ChangeEventQueue<?> queue) {
        super(VitessConnector.class, connectorConfig, queue);
    }

    @Override
    protected boolean isRetriable(Throwable throwable) {
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException exception = (StatusRuntimeException)throwable;
            String description = exception.getStatus().getDescription();
            LOGGER.info("Exception code: {} and description: {}", (Object)exception.getStatus().getCode(), (Object)description);
            switch (exception.getStatus().getCode()) {
                case CANCELLED: {
                    return description != null && description.contains("client connection is closing");
                }
                case UNAVAILABLE: {
                    return true;
                }
                case UNKNOWN: {
                    return description != null && (description.equals("stream timeout") || description.contains("vstream ended unexpectedly") || description.contains("unexpected server EOF"));
                }
            }
        }
        return false;
    }
}

