/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.runtime.operators.transform.PreTransformChangeInfo;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.operators.transform.TransformFilter;
import org.apache.flink.cdc.runtime.operators.transform.TransformProjection;
import org.apache.flink.cdc.runtime.parser.TransformParser;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;

public class PreTransformProcessor {
    private PreTransformChangeInfo tableChangeInfo;
    private TransformProjection transformProjection;
    @Nullable
    private TransformFilter transformFilter;
    private List<Boolean> cachedProjectionColumnsState;

    public PreTransformProcessor(PreTransformChangeInfo tableChangeInfo, TransformProjection transformProjection, @Nullable TransformFilter transformFilter) {
        this.tableChangeInfo = tableChangeInfo;
        this.transformProjection = transformProjection;
        this.transformFilter = transformFilter;
        this.cachedProjectionColumnsState = this.cacheIsProjectionColumnMap(tableChangeInfo, transformProjection);
    }

    public boolean hasTableChangeInfo() {
        return this.tableChangeInfo != null;
    }

    public CreateTableEvent preTransformCreateTableEvent(CreateTableEvent createTableEvent) {
        List<Column> preTransformColumns = TransformParser.generateReferencedColumns(this.transformProjection.getProjection(), this.transformFilter != null ? this.transformFilter.getExpression() : null, createTableEvent.getSchema().getColumns());
        Schema schema = createTableEvent.getSchema().copy(preTransformColumns);
        return new CreateTableEvent(createTableEvent.tableId(), schema);
    }

    public BinaryRecordData processFillDataField(BinaryRecordData data) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        List<Column> columns = this.tableChangeInfo.getPreTransformedSchema().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (this.cachedProjectionColumnsState.get(i).booleanValue()) {
                valueList.add(null);
                continue;
            }
            valueList.add(this.getValueFromBinaryRecordData(columns.get(i).getName(), data, this.tableChangeInfo.getSourceSchema().getColumns(), this.tableChangeInfo.getSourceFieldGetters()));
        }
        return this.tableChangeInfo.getPreTransformedRecordDataGenerator().generate(valueList.toArray(new Object[0]));
    }

    private Object getValueFromBinaryRecordData(String columnName, BinaryRecordData binaryRecordData, List<Column> columns, RecordData.FieldGetter[] fieldGetters) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columnName.equals(columns.get(i).getName())) continue;
            return DataTypeConverter.convert(fieldGetters[i].getFieldOrNull(binaryRecordData), columns.get(i).getType());
        }
        return null;
    }

    private List<Boolean> cacheIsProjectionColumnMap(PreTransformChangeInfo tableChangeInfo, TransformProjection transformProjection) {
        ArrayList<Boolean> cachedMap = new ArrayList<Boolean>();
        if (!this.hasTableChangeInfo()) {
            return cachedMap;
        }
        for (Column column : tableChangeInfo.getPreTransformedSchema().getColumns()) {
            boolean isProjectionColumn = false;
            for (ProjectionColumn projectionColumn : transformProjection.getProjectionColumns()) {
                if (!column.getName().equals(projectionColumn.getColumnName()) || !projectionColumn.isValidTransformedProjectionColumn()) continue;
                isProjectionColumn = true;
                break;
            }
            cachedMap.add(isProjectionColumn);
        }
        return cachedMap;
    }
}

