/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.configuration.description;

import java.util.EnumSet;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.configuration.description.BlockElement;
import org.apache.flink.cdc.common.configuration.description.Description;
import org.apache.flink.cdc.common.configuration.description.LineBreakElement;
import org.apache.flink.cdc.common.configuration.description.LinkElement;
import org.apache.flink.cdc.common.configuration.description.ListElement;
import org.apache.flink.cdc.common.configuration.description.TextElement;

@PublicEvolving
public abstract class Formatter {
    private final StringBuilder state = new StringBuilder();
    private static final String TEMPORARY_PLACEHOLDER = "randomPlaceholderForStringFormat";

    public String format(Description description) {
        for (BlockElement blockElement : description.getBlocks()) {
            blockElement.format(this);
        }
        return this.finalizeFormatting();
    }

    public void format(LinkElement element) {
        this.formatLink(this.state, element.getLink(), element.getText());
    }

    public void format(TextElement element) {
        String[] inlineElements = (String[])element.getElements().stream().map(el -> {
            Formatter formatter = this.newInstance();
            el.format(formatter);
            return formatter.finalizeFormatting();
        }).toArray(String[]::new);
        this.formatText(this.state, Formatter.escapeFormatPlaceholder(element.getFormat()), inlineElements, element.getStyles());
    }

    public void format(LineBreakElement element) {
        this.formatLineBreak(this.state);
    }

    public void format(ListElement element) {
        String[] inlineElements = (String[])element.getEntries().stream().map(el -> {
            Formatter formatter = this.newInstance();
            el.format(formatter);
            return formatter.finalizeFormatting();
        }).toArray(String[]::new);
        this.formatList(this.state, inlineElements);
    }

    private String finalizeFormatting() {
        String result = this.state.toString();
        this.state.setLength(0);
        return result.replaceAll("%%", "%");
    }

    protected abstract void formatLink(StringBuilder var1, String var2, String var3);

    protected abstract void formatLineBreak(StringBuilder var1);

    protected abstract void formatText(StringBuilder var1, String var2, String[] var3, EnumSet<TextElement.TextStyle> var4);

    protected abstract void formatList(StringBuilder var1, String[] var2);

    protected abstract Formatter newInstance();

    private static String escapeFormatPlaceholder(String value) {
        return value.replaceAll("%s", TEMPORARY_PLACEHOLDER).replaceAll("%", "%%").replaceAll(TEMPORARY_PLACEHOLDER, "%s");
    }
}

