/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.schema;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.MetadataColumn;
import org.apache.flink.cdc.common.schema.PhysicalColumn;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.runtime.serializer.EnumSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.schema.MetadataColumnSerializer;
import org.apache.flink.cdc.runtime.serializer.schema.PhysicalColumnSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class ColumnSerializer
extends TypeSerializerSingleton<Column> {
    private static final long serialVersionUID = 1L;
    public static final ColumnSerializer INSTANCE = new ColumnSerializer();
    private final EnumSerializer<ColumnType> enumSerializer = new EnumSerializer<ColumnType>(ColumnType.class);
    private final PhysicalColumnSerializer physicalColumnSerializer = PhysicalColumnSerializer.INSTANCE;
    private final MetadataColumnSerializer metadataColumnSerializer = MetadataColumnSerializer.INSTANCE;

    public boolean isImmutableType() {
        return false;
    }

    public Column createInstance() {
        return Column.physicalColumn("unknown", DataTypes.BIGINT());
    }

    public Column copy(Column from) {
        if (from instanceof PhysicalColumn) {
            return this.physicalColumnSerializer.copy((PhysicalColumn)from);
        }
        if (from instanceof MetadataColumn) {
            return this.metadataColumnSerializer.copy((MetadataColumn)from);
        }
        throw new IllegalArgumentException("Unknown column type: " + from);
    }

    public Column copy(Column from, Column reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Column record, DataOutputView target) throws IOException {
        if (record instanceof PhysicalColumn) {
            this.enumSerializer.serialize(ColumnType.PHYSICAL, target);
            this.physicalColumnSerializer.serialize((PhysicalColumn)record, target);
        } else if (record instanceof MetadataColumn) {
            this.enumSerializer.serialize(ColumnType.METADATA, target);
            this.metadataColumnSerializer.serialize((MetadataColumn)record, target);
        } else {
            throw new IOException("Unknown column type: " + record);
        }
    }

    public Column deserialize(DataInputView source) throws IOException {
        ColumnType columnType = (ColumnType)((Object)this.enumSerializer.deserialize(source));
        switch (columnType) {
            case METADATA: {
                return this.metadataColumnSerializer.deserialize(source);
            }
            case PHYSICAL: {
                return this.physicalColumnSerializer.deserialize(source);
            }
        }
        throw new IOException("Unknown column type: " + (Object)((Object)columnType));
    }

    public Column deserialize(Column reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<Column> snapshotConfiguration() {
        return new ColumnSerializerSnapshot();
    }

    static enum ColumnType {
        PHYSICAL,
        METADATA;

    }

    public static final class ColumnSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Column> {
        public ColumnSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

