/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.IllegalWorkerStateException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.WorkerSinkTask;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.sink.ErrantRecordReporter;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkTaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerSinkTaskContext
implements SinkTaskContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
    private final KafkaConsumer<byte[], byte[]> consumer;
    private final WorkerSinkTask sinkTask;
    private final ClusterConfigState configState;
    private final Set<TopicPartition> pausedPartitions;
    private long timeoutMs = -1L;
    private boolean commitRequested;

    public WorkerSinkTaskContext(KafkaConsumer<byte[], byte[]> consumer, WorkerSinkTask sinkTask, ClusterConfigState configState) {
        this.consumer = consumer;
        this.sinkTask = sinkTask;
        this.configState = configState;
        this.pausedPartitions = new HashSet<TopicPartition>();
    }

    @Override
    public Map<String, String> configs() {
        return this.configState.taskConfig(this.sinkTask.id());
    }

    @Override
    public void offset(Map<TopicPartition, Long> offsets) {
        this.log.debug("{} Setting offsets for topic partitions {}", (Object)this, (Object)offsets);
        this.offsets.putAll(offsets);
    }

    @Override
    public void offset(TopicPartition tp, long offset) {
        this.log.debug("{} Setting offset for topic partition {} to {}", this, tp, offset);
        this.offsets.put(tp, offset);
    }

    public void clearOffsets() {
        this.offsets.clear();
    }

    public Map<TopicPartition, Long> offsets() {
        return this.offsets;
    }

    @Override
    public void timeout(long timeoutMs) {
        this.log.debug("{} Setting timeout to {} ms", (Object)this, (Object)timeoutMs);
        this.timeoutMs = timeoutMs;
    }

    public long timeout() {
        return this.timeoutMs;
    }

    @Override
    public Set<TopicPartition> assignment() {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to look up partition assignment until the task is initialized");
        }
        return this.consumer.assignment();
    }

    @Override
    public void pause(TopicPartition ... partitions) {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to pause consumption until the task is initialized");
        }
        try {
            Collections.addAll(this.pausedPartitions, partitions);
            if (this.sinkTask.shouldPause()) {
                this.log.debug("{} Connector is paused, so not pausing consumer's partitions {}", (Object)this, (Object)partitions);
            } else {
                this.consumer.pause(Arrays.asList(partitions));
                this.log.debug("{} Pausing partitions {}. Connector is not paused.", (Object)this, (Object)partitions);
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalWorkerStateException("SinkTasks may not pause partitions that are not currently assigned to them.", e);
        }
    }

    @Override
    public void resume(TopicPartition ... partitions) {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to resume consumption until the task is initialized");
        }
        try {
            this.pausedPartitions.removeAll(Arrays.asList(partitions));
            if (this.sinkTask.shouldPause()) {
                this.log.debug("{} Connector is paused, so not resuming consumer's partitions {}", (Object)this, (Object)partitions);
            } else {
                this.consumer.resume(Arrays.asList(partitions));
                this.log.debug("{} Resuming partitions: {}", (Object)this, (Object)partitions);
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalWorkerStateException("SinkTasks may not resume partitions that are not currently assigned to them.", e);
        }
    }

    public Set<TopicPartition> pausedPartitions() {
        return this.pausedPartitions;
    }

    @Override
    public void requestCommit() {
        this.log.debug("{} Requesting commit", (Object)this);
        this.commitRequested = true;
    }

    public boolean isCommitRequested() {
        return this.commitRequested;
    }

    public void clearCommitRequest() {
        this.commitRequested = false;
    }

    @Override
    public ErrantRecordReporter errantRecordReporter() {
        return this.sinkTask.workerErrantRecordReporter();
    }

    public String toString() {
        return "WorkerSinkTaskContext{id=" + this.sinkTask.id + '}';
    }
}

