/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.util.Arrays;
import java.util.OptionalInt;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.ArrayType;
import org.apache.flink.cdc.common.types.BigIntType;
import org.apache.flink.cdc.common.types.BinaryType;
import org.apache.flink.cdc.common.types.BooleanType;
import org.apache.flink.cdc.common.types.CharType;
import org.apache.flink.cdc.common.types.DataField;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeDefaultVisitor;
import org.apache.flink.cdc.common.types.DateType;
import org.apache.flink.cdc.common.types.DecimalType;
import org.apache.flink.cdc.common.types.DoubleType;
import org.apache.flink.cdc.common.types.FloatType;
import org.apache.flink.cdc.common.types.IntType;
import org.apache.flink.cdc.common.types.LocalZonedTimestampType;
import org.apache.flink.cdc.common.types.MapType;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.common.types.SmallIntType;
import org.apache.flink.cdc.common.types.TimeType;
import org.apache.flink.cdc.common.types.TimestampType;
import org.apache.flink.cdc.common.types.TinyIntType;
import org.apache.flink.cdc.common.types.VarBinaryType;
import org.apache.flink.cdc.common.types.VarCharType;
import org.apache.flink.cdc.common.types.ZonedTimestampType;

@PublicEvolving
public class DataTypes {
    private static final PrecisionExtractor PRECISION_EXTRACTOR = new PrecisionExtractor();
    private static final ScaleExtractor SCALE_EXTRACTOR = new ScaleExtractor();
    private static final LengthExtractor LENGTH_EXTRACTOR = new LengthExtractor();

    public static BinaryType BINARY(int length) {
        return new BinaryType(length);
    }

    public static VarBinaryType VARBINARY(int n) {
        return new VarBinaryType(n);
    }

    public static VarBinaryType BYTES() {
        return VarBinaryType.bytesType();
    }

    public static BooleanType BOOLEAN() {
        return new BooleanType();
    }

    public static IntType INT() {
        return new IntType();
    }

    public static TinyIntType TINYINT() {
        return new TinyIntType();
    }

    public static SmallIntType SMALLINT() {
        return new SmallIntType();
    }

    public static BigIntType BIGINT() {
        return new BigIntType();
    }

    public static FloatType FLOAT() {
        return new FloatType();
    }

    public static DoubleType DOUBLE() {
        return new DoubleType();
    }

    public static CharType CHAR(int length) {
        return new CharType(length);
    }

    public static DataType VARCHAR(int n) {
        return new VarCharType(n);
    }

    public static DataType STRING() {
        return VarCharType.stringType();
    }

    public static DecimalType DECIMAL(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static DateType DATE() {
        return new DateType();
    }

    public static TimeType TIME() {
        return new TimeType();
    }

    public static TimeType TIME(int precision) {
        return new TimeType(precision);
    }

    public static TimestampType TIMESTAMP() {
        return new TimestampType();
    }

    public static TimestampType TIMESTAMP(int precision) {
        return new TimestampType(precision);
    }

    public static ZonedTimestampType TIMESTAMP_TZ() {
        return new ZonedTimestampType();
    }

    public static ZonedTimestampType TIMESTAMP_TZ(int precision) {
        return new ZonedTimestampType(precision);
    }

    public static LocalZonedTimestampType TIMESTAMP_LTZ() {
        return new LocalZonedTimestampType();
    }

    public static LocalZonedTimestampType TIMESTAMP_LTZ(int precision) {
        return new LocalZonedTimestampType(precision);
    }

    public static ArrayType ARRAY(DataType element) {
        return new ArrayType(element);
    }

    public static MapType MAP(DataType keyType, DataType valueType) {
        return new MapType(keyType, valueType);
    }

    public static DataField FIELD(String name, DataType type) {
        return new DataField(name, type);
    }

    public static DataField FIELD(String name, DataType type, String description) {
        return new DataField(name, type, description);
    }

    public static RowType ROW(DataField ... fields) {
        return new RowType(Arrays.asList(fields));
    }

    public static RowType ROW(DataType ... fieldTypes) {
        return RowType.builder().fields(fieldTypes).build();
    }

    public static OptionalInt getPrecision(DataType dataType) {
        return dataType.accept(PRECISION_EXTRACTOR);
    }

    public static OptionalInt getLength(DataType dataType) {
        return dataType.accept(LENGTH_EXTRACTOR);
    }

    public static OptionalInt getScale(DataType dataType) {
        return dataType.accept(SCALE_EXTRACTOR);
    }

    private static class LengthExtractor
    extends DataTypeDefaultVisitor<OptionalInt> {
        private LengthExtractor() {
        }

        @Override
        public OptionalInt visit(CharType charType) {
            return OptionalInt.of(charType.getLength());
        }

        @Override
        public OptionalInt visit(VarCharType varCharType) {
            return OptionalInt.of(varCharType.getLength());
        }

        @Override
        public OptionalInt visit(BinaryType binaryType) {
            return OptionalInt.of(binaryType.getLength());
        }

        @Override
        public OptionalInt visit(VarBinaryType varBinaryType) {
            return OptionalInt.of(varBinaryType.getLength());
        }

        @Override
        protected OptionalInt defaultMethod(DataType dataType) {
            return OptionalInt.empty();
        }
    }

    private static class ScaleExtractor
    extends DataTypeDefaultVisitor<OptionalInt> {
        private ScaleExtractor() {
        }

        @Override
        public OptionalInt visit(DecimalType decimalType) {
            return OptionalInt.of(decimalType.getScale());
        }

        @Override
        protected OptionalInt defaultMethod(DataType dataType) {
            return OptionalInt.empty();
        }
    }

    private static class PrecisionExtractor
    extends DataTypeDefaultVisitor<OptionalInt> {
        private PrecisionExtractor() {
        }

        @Override
        public OptionalInt visit(DecimalType decimalType) {
            return OptionalInt.of(decimalType.getPrecision());
        }

        @Override
        public OptionalInt visit(TimeType timeType) {
            return OptionalInt.of(timeType.getPrecision());
        }

        @Override
        public OptionalInt visit(TimestampType timestampType) {
            return OptionalInt.of(timestampType.getPrecision());
        }

        @Override
        public OptionalInt visit(LocalZonedTimestampType localZonedTimestampType) {
            return OptionalInt.of(localZonedTimestampType.getPrecision());
        }

        @Override
        public OptionalInt visit(ZonedTimestampType zonedTimestampType) {
            return OptionalInt.of(zonedTimestampType.getPrecision());
        }

        @Override
        protected OptionalInt defaultMethod(DataType dataType) {
            return OptionalInt.empty();
        }
    }
}

