/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.configuration;

public class FallbackKey {
    private final String key;
    private final boolean isDeprecated;

    static FallbackKey createFallbackKey(String key) {
        return new FallbackKey(key, false);
    }

    static FallbackKey createDeprecatedKey(String key) {
        return new FallbackKey(key, true);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    private FallbackKey(String key, boolean isDeprecated) {
        this.key = key;
        this.isDeprecated = isDeprecated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == FallbackKey.class) {
            FallbackKey that = (FallbackKey)o;
            return this.key.equals(that.key) && this.isDeprecated == that.isDeprecated;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + (this.isDeprecated ? 1 : 0);
    }

    public String toString() {
        return String.format("{key=%s, isDeprecated=%s}", this.key, this.isDeprecated);
    }
}

