/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.typeutils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.LocalZonedTimestampData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.cdc.common.data.binary.BinaryStringData;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.RowType;

public class DataTypeConverter {
    static final long MILLISECONDS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    static final long NANOSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    static final long NANOSECONDS_PER_DAY = TimeUnit.DAYS.toNanos(1L);

    public static RowType toRowType(List<Column> columnList) {
        DataType[] dataTypes = (DataType[])columnList.stream().map(Column::getType).toArray(DataType[]::new);
        String[] columnNames = (String[])columnList.stream().map(Column::getName).toArray(String[]::new);
        return RowType.of(dataTypes, columnNames);
    }

    public static Class<?> convertOriginalClass(DataType dataType) {
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case BIGINT: {
                return Long.class;
            }
            case DATE: {
                return Integer.class;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return Integer.class;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TimestampData.class;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return LocalZonedTimestampData.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case CHAR: 
            case VARCHAR: {
                return String.class;
            }
            case BINARY: 
            case VARBINARY: {
                return byte[].class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case ROW: {
                return Object.class;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    public static SqlTypeName convertCalciteType(DataType dataType) {
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return SqlTypeName.BOOLEAN;
            }
            case TINYINT: {
                return SqlTypeName.TINYINT;
            }
            case SMALLINT: {
                return SqlTypeName.SMALLINT;
            }
            case INTEGER: {
                return SqlTypeName.INTEGER;
            }
            case BIGINT: {
                return SqlTypeName.BIGINT;
            }
            case DATE: {
                return SqlTypeName.DATE;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return SqlTypeName.TIMESTAMP;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
            }
            case FLOAT: {
                return SqlTypeName.FLOAT;
            }
            case DOUBLE: {
                return SqlTypeName.DOUBLE;
            }
            case CHAR: {
                return SqlTypeName.CHAR;
            }
            case VARCHAR: {
                return SqlTypeName.VARCHAR;
            }
            case BINARY: {
                return SqlTypeName.BINARY;
            }
            case VARBINARY: {
                return SqlTypeName.VARBINARY;
            }
            case DECIMAL: {
                return SqlTypeName.DECIMAL;
            }
            case ROW: {
                return SqlTypeName.ROW;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    public static DataType convertCalciteRelDataTypeToDataType(RelDataType relDataType) {
        switch (relDataType.getSqlTypeName()) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case TINYINT: {
                return DataTypes.TINYINT();
            }
            case SMALLINT: {
                return DataTypes.SMALLINT();
            }
            case INTEGER: {
                return DataTypes.INT();
            }
            case BIGINT: {
                return DataTypes.BIGINT();
            }
            case DATE: {
                return DataTypes.DATE();
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return DataTypes.TIME(relDataType.getPrecision());
            }
            case TIMESTAMP: {
                return DataTypes.TIMESTAMP(relDataType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataTypes.TIMESTAMP_LTZ(relDataType.getPrecision());
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case CHAR: 
            case VARCHAR: {
                return DataTypes.STRING();
            }
            case BINARY: {
                return DataTypes.BINARY(Integer.MAX_VALUE);
            }
            case VARBINARY: {
                return DataTypes.VARBINARY(Integer.MAX_VALUE);
            }
            case DECIMAL: {
                return DataTypes.DECIMAL(relDataType.getPrecision(), relDataType.getScale());
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + relDataType.getSqlTypeName());
    }

    public static Object convert(Object value, DataType dataType) {
        if (value == null) {
            return null;
        }
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return DataTypeConverter.convertToBoolean(value);
            }
            case TINYINT: {
                return DataTypeConverter.convertToByte(value);
            }
            case SMALLINT: {
                return DataTypeConverter.convertToShort(value);
            }
            case INTEGER: {
                return DataTypeConverter.convertToInt(value);
            }
            case BIGINT: {
                return DataTypeConverter.convertToLong(value);
            }
            case DATE: {
                return DataTypeConverter.convertToDate(value);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return DataTypeConverter.convertToTime(value);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return DataTypeConverter.convertToTimestamp(value);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataTypeConverter.convertToLocalTimeZoneTimestamp(value);
            }
            case FLOAT: {
                return DataTypeConverter.convertToFloat(value);
            }
            case DOUBLE: {
                return DataTypeConverter.convertToDouble(value);
            }
            case CHAR: 
            case VARCHAR: {
                return DataTypeConverter.convertToString(value);
            }
            case BINARY: 
            case VARBINARY: {
                return DataTypeConverter.convertToBinary(value);
            }
            case DECIMAL: {
                return DataTypeConverter.convertToDecimal(value);
            }
            case ROW: {
                return value;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    public static Object convertToOriginal(Object value, DataType dataType) {
        if (value == null) {
            return null;
        }
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return DataTypeConverter.convertToBoolean(value);
            }
            case TINYINT: {
                return DataTypeConverter.convertToByte(value);
            }
            case SMALLINT: {
                return DataTypeConverter.convertToShort(value);
            }
            case INTEGER: {
                return DataTypeConverter.convertToInt(value);
            }
            case BIGINT: {
                return DataTypeConverter.convertToLong(value);
            }
            case DATE: {
                return DataTypeConverter.convertToDate(value);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return DataTypeConverter.convertToTime(value);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return DataTypeConverter.convertToTimestamp(value);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataTypeConverter.convertToLocalTimeZoneTimestamp(value);
            }
            case FLOAT: {
                return DataTypeConverter.convertToFloat(value);
            }
            case DOUBLE: {
                return DataTypeConverter.convertToDouble(value);
            }
            case CHAR: 
            case VARCHAR: {
                return DataTypeConverter.convertToStringOriginal(value);
            }
            case BINARY: 
            case VARBINARY: {
                return DataTypeConverter.convertToBinary(value);
            }
            case DECIMAL: {
                return DataTypeConverter.convertToDecimalOriginal(value);
            }
            case ROW: {
                return value;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    private static Object convertToBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof Byte) {
            return (Byte)obj == 1;
        }
        if (obj instanceof Short) {
            return (Short)obj == 1;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    private static Object convertToByte(Object obj) {
        return Byte.parseByte(obj.toString());
    }

    private static Object convertToShort(Object obj) {
        return Short.parseShort(obj.toString());
    }

    private static Object convertToInt(Object obj) {
        if (obj instanceof Integer) {
            return obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        return Integer.parseInt(obj.toString());
    }

    private static Object convertToLong(Object obj) {
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return obj;
        }
        return Long.parseLong(obj.toString());
    }

    private static Object convertToFloat(Object obj) {
        if (obj instanceof Float) {
            return obj;
        }
        if (obj instanceof Double) {
            return Float.valueOf(((Double)obj).floatValue());
        }
        return Float.valueOf(Float.parseFloat(obj.toString()));
    }

    private static Object convertToDouble(Object obj) {
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        if (obj instanceof Double) {
            return obj;
        }
        return Double.parseDouble(obj.toString());
    }

    private static Object convertToDate(Object obj) {
        return (int)DataTypeConverter.toLocalDate(obj).toEpochDay();
    }

    private static LocalDate toLocalDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalDate) {
            return (LocalDate)obj;
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalDate();
        }
        if (obj instanceof Date) {
            return ((Date)obj).toLocalDate();
        }
        if (obj instanceof Time) {
            throw new IllegalArgumentException("Unable to convert to LocalDate from a java.sql.Time value '" + obj + "'");
        }
        if (obj instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)obj;
            return LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
        }
        if (obj instanceof Long) {
            return LocalDate.ofEpochDay((Long)obj);
        }
        if (obj instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)obj).intValue());
        }
        throw new IllegalArgumentException("Unable to convert to LocalDate from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToTime(Object obj) {
        if (obj instanceof Integer) {
            return obj;
        }
        return DataTypeConverter.toLocalTime(obj).toSecondOfDay() * 1000;
    }

    private static LocalTime toLocalTime(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalTime) {
            return (LocalTime)obj;
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalTime();
        }
        if (obj instanceof Date) {
            throw new IllegalArgumentException("Unable to convert to LocalDate from a java.sql.Date value '" + obj + "'");
        }
        if (obj instanceof Time) {
            Time time = (Time)obj;
            long millis = (int)(time.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalTime.of(time.getHours(), time.getMinutes(), time.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return LocalTime.of(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
        }
        if (obj instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)obj;
            long millis = (int)(date.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof Duration) {
            Long value = ((Duration)obj).toNanos();
            if (value >= 0L && value <= NANOSECONDS_PER_DAY) {
                return LocalTime.ofNanoOfDay(value);
            }
            throw new IllegalArgumentException("Time values must use number of milliseconds greater than 0 and less than 86400000000000");
        }
        throw new IllegalArgumentException("Unable to convert to LocalTime from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToTimestamp(Object obj) {
        if (obj instanceof Long) {
            return TimestampData.fromMillis((Long)obj);
        }
        if (obj instanceof Timestamp) {
            return TimestampData.fromTimestamp((Timestamp)obj);
        }
        if (obj instanceof TimestampData) {
            return obj;
        }
        throw new IllegalArgumentException("Unable to convert to TIMESTAMP from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToLocalTimeZoneTimestamp(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            Instant instant = Instant.parse(str);
            return LocalZonedTimestampData.fromInstant(instant);
        }
        if (obj instanceof Long) {
            return LocalZonedTimestampData.fromEpochMillis((Long)obj);
        }
        if (obj instanceof LocalZonedTimestampData) {
            return obj;
        }
        throw new IllegalArgumentException("Unable to convert to TIMESTAMP_LTZ from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToString(Object obj) {
        return BinaryStringData.fromString(obj.toString());
    }

    private static Object convertToStringOriginal(Object obj) {
        return String.valueOf(obj);
    }

    private static Object convertToBinary(Object obj) {
        if (obj instanceof byte[]) {
            return obj;
        }
        if (obj instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)obj;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        throw new UnsupportedOperationException("Unsupported BYTES value type: " + obj.getClass().getSimpleName());
    }

    private static Object convertToDecimal(Object obj) {
        if (obj instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)obj;
            return DecimalData.fromBigDecimal(bigDecimalValue, bigDecimalValue.precision(), bigDecimalValue.scale());
        }
        if (obj instanceof DecimalData) {
            return obj;
        }
        throw new UnsupportedOperationException("Unsupported Decimal value type: " + obj.getClass().getSimpleName());
    }

    private static Object convertToDecimalOriginal(Object obj) {
        if (obj instanceof BigDecimal) {
            return obj;
        }
        if (obj instanceof DecimalData) {
            DecimalData decimalData = (DecimalData)obj;
            return decimalData.toBigDecimal();
        }
        throw new UnsupportedOperationException("Unsupported Decimal value type: " + obj.getClass().getSimpleName());
    }
}

