/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.schema;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.PhysicalColumn;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.runtime.serializer.StringSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.schema.DataTypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class PhysicalColumnSerializer
extends TypeSerializerSingleton<PhysicalColumn> {
    private static final long serialVersionUID = 1L;
    public static final PhysicalColumnSerializer INSTANCE = new PhysicalColumnSerializer();
    private final DataTypeSerializer dataTypeSerializer = new DataTypeSerializer();
    private final StringSerializer stringSerializer = StringSerializer.INSTANCE;

    public boolean isImmutableType() {
        return false;
    }

    public PhysicalColumn createInstance() {
        return Column.physicalColumn("unknow", DataTypes.BIGINT());
    }

    public PhysicalColumn copy(PhysicalColumn from) {
        return Column.physicalColumn(this.stringSerializer.copy(from.getName()), this.dataTypeSerializer.copy(from.getType()), this.stringSerializer.copy(from.getComment()));
    }

    public PhysicalColumn copy(PhysicalColumn from, PhysicalColumn reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(PhysicalColumn record, DataOutputView target) throws IOException {
        this.stringSerializer.serialize(record.getName(), target);
        this.dataTypeSerializer.serialize(record.getType(), target);
        this.stringSerializer.serialize(record.getComment(), target);
    }

    public PhysicalColumn deserialize(DataInputView source) throws IOException {
        String name = this.stringSerializer.deserialize(source);
        DataType dataType = this.dataTypeSerializer.deserialize(source);
        String comment = this.stringSerializer.deserialize(source);
        return Column.physicalColumn(name, dataType, comment);
    }

    public PhysicalColumn deserialize(PhysicalColumn reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<PhysicalColumn> snapshotConfiguration() {
        return new PhysicalColumnSerializerSnapshot();
    }

    public static final class PhysicalColumnSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<PhysicalColumn> {
        public PhysicalColumnSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

