/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionKey;
import org.apache.flink.shaded.guava31.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;
import org.apache.flink.util.FlinkRuntimeException;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;

public class TransformExpressionCompiler {
    static final Cache<TransformExpressionKey, ExpressionEvaluator> COMPILED_EXPRESSION_CACHE = CacheBuilder.newBuilder().softValues().build();

    public static void cleanUp() {
        COMPILED_EXPRESSION_CACHE.cleanUp();
    }

    public static ExpressionEvaluator compileExpression(TransformExpressionKey key) {
        try {
            return COMPILED_EXPRESSION_CACHE.get(key, () -> {
                ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
                expressionEvaluator.setParameters(key.getArgumentNames().toArray(new String[0]), key.getArgumentClasses().toArray(new Class[0]));
                expressionEvaluator.setExpressionType(key.getReturnClass());
                try {
                    expressionEvaluator.cook(key.getExpression());
                }
                catch (CompileException e) {
                    throw new InvalidProgramException("Expression cannot be compiled. This is a bug. Please file an issue.\nExpression: " + key.getExpression(), (Throwable)e);
                }
                return expressionEvaluator;
            });
        }
        catch (Exception e) {
            throw new FlinkRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

