/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.PluginType;

public class PluginInfo {
    private final String className;
    private final PluginType type;
    private final String version;

    @JsonCreator
    public PluginInfo(@JsonProperty(value="class") String className, @JsonProperty(value="type") PluginType type, @JsonProperty(value="version") String version) {
        this.className = className;
        this.type = type;
        this.version = version;
    }

    public PluginInfo(PluginDesc<?> plugin) {
        this(plugin.className(), plugin.type(), plugin.version());
    }

    @JsonProperty(value="class")
    public String className() {
        return this.className;
    }

    @JsonProperty(value="type")
    public String type() {
        return this.type.toString();
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NoVersionFilter.class)
    public String version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        return Objects.equals(this.className, that.className) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.className, this.type, this.version});
    }

    public String toString() {
        return "PluginInfo{className='" + this.className + '\'' + ", type=" + this.type.toString() + ", version='" + this.version + '\'' + '}';
    }

    public static final class NoVersionFilter {
        public boolean equals(Object obj) {
            return "undefined".equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

