/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table;

import java.util.ArrayList;
import org.apache.flink.cdc.connectors.tidb.table.TiKVMetadataConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;

public class TiKVReadableMetadata {
    private final String key;
    private final DataType dataType;
    private final TiKVMetadataConverter converter;

    TiKVReadableMetadata(String key, DataType dataType, TiKVMetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public TiKVMetadataConverter getConverter() {
        return this.converter;
    }

    public static TiKVReadableMetadata createTableNameMetadata(final String tableName) {
        return new TiKVReadableMetadata("table_name", (DataType)DataTypes.STRING().notNull(), new TiKVMetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(TiKVMetadataConverter.TiKVRowValue row) {
                return StringData.fromString((String)tableName);
            }
        });
    }

    public static TiKVReadableMetadata createDatabaseNameMetadata(final String database) {
        return new TiKVReadableMetadata("database_name", (DataType)DataTypes.STRING().notNull(), new TiKVMetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(TiKVMetadataConverter.TiKVRowValue row) {
                return StringData.fromString((String)database);
            }
        });
    }

    public static TiKVReadableMetadata createOpTsMetadata() {
        return new TiKVReadableMetadata("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new TiKVMetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(TiKVMetadataConverter.TiKVRowValue row) {
                if (row.isSnapshotRecord) {
                    return TimestampData.fromEpochMillis((long)0L);
                }
                return TimestampData.fromEpochMillis((long)row.row.getStartTs());
            }
        });
    }

    public static TiKVReadableMetadata[] createTiKVReadableMetadata(String database, String tableName) {
        ArrayList<TiKVReadableMetadata> list = new ArrayList<TiKVReadableMetadata>();
        list.add(TiKVReadableMetadata.createDatabaseNameMetadata(database));
        list.add(TiKVReadableMetadata.createTableNameMetadata(tableName));
        list.add(TiKVReadableMetadata.createOpTsMetadata());
        return list.toArray(new TiKVReadableMetadata[0]);
    }
}

