/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.tikv.common.expression.Constant;
import org.tikv.common.expression.FuncCallExpr;
import org.tikv.common.types.DataType;
import org.tikv.common.types.DateTimeType;
import org.tikv.common.types.DateType;
import org.tikv.common.types.IntegerType;
import org.tikv.common.types.StringType;

public class FuncCallExprEval {
    private static final Map<FuncCallExpr.Type, Function<Constant, Constant>> evalMap = new HashMap<FuncCallExpr.Type, Function<Constant, Constant>>();

    static Function<Constant, Constant> getEvalFn(FuncCallExpr.Type tp) {
        if (evalMap.containsKey((Object)tp)) {
            return evalMap.get((Object)tp);
        }
        return null;
    }

    static {
        evalMap.put(FuncCallExpr.Type.YEAR, literal -> {
            DataType type = literal.getDataType();
            if (type instanceof StringType) {
                DateTime date = DateTime.parse((String)literal.getValue());
                return Constant.create(date.getYear(), IntegerType.INT);
            }
            if (type instanceof DateType) {
                DateTime date = (DateTime)literal.getValue();
                return Constant.create(date.getYear(), IntegerType.INT);
            }
            if (type instanceof DateTimeType) {
                DateTime date = (DateTime)literal.getValue();
                return Constant.create(date.getYear(), IntegerType.INT);
            }
            throw new UnsupportedOperationException(String.format("cannot apply year on %s", type.getName()));
        });
    }
}

