/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.columnar;

import java.math.BigDecimal;
import org.tikv.common.columnar.TiColumnVector;
import org.tikv.common.row.Row;
import org.tikv.common.types.DataType;

public class TiRowColumnVector
extends TiColumnVector {
    private final int colIdx;
    private Row[] rows;

    public TiRowColumnVector(DataType type, int colIdx, Row[] rows, int numOfRows) {
        super(type, numOfRows);
        this.rows = rows;
        this.colIdx = colIdx;
    }

    @Override
    public void close() {
        this.rows = null;
    }

    @Override
    public boolean hasNull() {
        throw new UnsupportedOperationException("row-wise column vector does not support this operation");
    }

    @Override
    public int numNulls() {
        throw new UnsupportedOperationException("row-wise column vector does not support this operation");
    }

    @Override
    public boolean isNullAt(int rowId) {
        return this.rows[rowId].get(this.colIdx, null) == null;
    }

    @Override
    public boolean getBoolean(int rowId) {
        return this.rows[rowId].getLong(this.colIdx) == 1L;
    }

    @Override
    public byte getByte(int rowId) {
        return (byte)this.rows[rowId].getLong(this.colIdx);
    }

    @Override
    public short getShort(int rowId) {
        return (short)this.rows[rowId].getLong(this.colIdx);
    }

    @Override
    public int getInt(int rowId) {
        return (int)this.rows[rowId].getLong(this.colIdx);
    }

    @Override
    public long getLong(int rowId) {
        return this.rows[rowId].getLong(this.colIdx);
    }

    @Override
    public float getFloat(int rowId) {
        return ((Number)this.rows[rowId].getDouble(this.colIdx)).floatValue();
    }

    @Override
    public double getDouble(int rowId) {
        return this.rows[rowId].getDouble(this.colIdx);
    }

    @Override
    public BigDecimal getDecimal(int rowId, int precision, int scale) {
        Object val = this.rows[rowId].get(this.colIdx, null);
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Long) {
            return BigDecimal.valueOf((Long)val);
        }
        throw new UnsupportedOperationException(String.format("failed to getDecimal and the value is %s:%s", val.getClass().getCanonicalName(), val));
    }

    @Override
    public String getUTF8String(int rowId) {
        return this.rows[rowId].getString(this.colIdx);
    }

    @Override
    public byte[] getBinary(int rowId) {
        return this.rows[rowId].getBytes(this.colIdx);
    }

    @Override
    protected TiColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("row-wise column vector does not support this operation");
    }
}

