/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.shade.io.prometheus.client.exporter.HTTPServer;
import org.tikv.shade.io.prometheus.client.hotspot.DefaultExports;

public class MetricsServer {
    private static final Logger logger = LoggerFactory.getLogger(MetricsServer.class);
    private static MetricsServer METRICS_SERVER_INSTANCE = null;
    private static int metricsServerRefCount = 0;
    private final int port;
    private final HTTPServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricsServer getInstance(TiConfiguration conf) {
        if (!conf.isMetricsEnable()) {
            return null;
        }
        Class<MetricsServer> clazz = MetricsServer.class;
        synchronized (MetricsServer.class) {
            int port = conf.getMetricsPort();
            if (METRICS_SERVER_INSTANCE != null) {
                if (port != MetricsServer.METRICS_SERVER_INSTANCE.port) {
                    throw new IllegalArgumentException(String.format("Do dot support multiple tikv.metrics.port, which are %d and %d", port, MetricsServer.METRICS_SERVER_INSTANCE.port));
                }
            } else {
                METRICS_SERVER_INSTANCE = new MetricsServer(port);
            }
            ++metricsServerRefCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return METRICS_SERVER_INSTANCE;
        }
    }

    private MetricsServer(int port) {
        try {
            this.port = port;
            DefaultExports.initialize();
            this.server = new HTTPServer(port, true);
            logger.info("http server is up " + this.server.getPort());
        }
        catch (Exception e) {
            logger.error("http server not up");
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<MetricsServer> clazz = MetricsServer.class;
        synchronized (MetricsServer.class) {
            if (metricsServerRefCount == 1) {
                if (this.server != null) {
                    this.server.stop();
                    logger.info("Metrics server on " + this.server.getPort() + " is stopped");
                }
                METRICS_SERVER_INSTANCE = null;
            }
            if (metricsServerRefCount >= 1) {
                --metricsServerRefCount;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

