/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.debezium.event;

import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.time.ZonedTimestamp;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Optional;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.types.DataField;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.debezium.event.SchemaDataTypeInference;

@Internal
public class DebeziumSchemaDataTypeInference
implements SchemaDataTypeInference,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PRECISION_PARAMETER_KEY = "connect.decimal.precision";
    public static final int DEFAULT_DECIMAL_PRECISION = 20;

    @Override
    public DataType infer(Object value, Schema schema) {
        return schema.isOptional() ? this.infer(value, schema, schema.type()) : this.infer(value, schema, schema.type()).notNull();
    }

    protected DataType infer(Object value, Schema schema, Schema.Type type) {
        switch (type) {
            case INT8: {
                return this.inferInt8(value, schema);
            }
            case INT16: {
                return this.inferInt16(value, schema);
            }
            case INT32: {
                return this.inferInt32(value, schema);
            }
            case INT64: {
                return this.inferInt64(value, schema);
            }
            case FLOAT32: {
                return this.inferFloat32(value, schema);
            }
            case FLOAT64: {
                return this.inferFloat64(value, schema);
            }
            case BOOLEAN: {
                return this.inferBoolean(value, schema);
            }
            case STRING: {
                return this.inferString(value, schema);
            }
            case BYTES: {
                return this.inferBytes(value, schema);
            }
            case STRUCT: {
                return this.inferStruct(value, schema);
            }
            case ARRAY: {
                return this.inferArray(value, schema);
            }
            case MAP: {
                return this.inferMap(value, schema);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + schema.type().getName());
    }

    protected DataType inferBoolean(Object value, Schema schema) {
        return DataTypes.BOOLEAN();
    }

    protected DataType inferInt8(Object value, Schema schema) {
        return DataTypes.TINYINT();
    }

    protected DataType inferInt16(Object value, Schema schema) {
        return DataTypes.SMALLINT();
    }

    protected DataType inferInt32(Object value, Schema schema) {
        if ("io.debezium.time.Date".equals(schema.name()) || "org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Date".equals(schema.name())) {
            return DataTypes.DATE();
        }
        if ("io.debezium.time.Time".equals(schema.name())) {
            return DataTypes.TIME(3);
        }
        if ("org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Time".equals(schema.name())) {
            return DataTypes.TIME(3);
        }
        return DataTypes.INT();
    }

    protected DataType inferInt64(Object value, Schema schema) {
        if ("io.debezium.time.MicroTime".equals(schema.name())) {
            return DataTypes.TIME(6);
        }
        if ("io.debezium.time.NanoTime".equals(schema.name())) {
            return DataTypes.TIME(9);
        }
        if ("io.debezium.time.Timestamp".equals(schema.name()) || "org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Timestamp".equals(schema.name())) {
            return DataTypes.TIMESTAMP(3);
        }
        if ("io.debezium.time.MicroTimestamp".equals(schema.name())) {
            return DataTypes.TIMESTAMP(6);
        }
        if ("io.debezium.time.NanoTimestamp".equals(schema.name())) {
            return DataTypes.TIMESTAMP(9);
        }
        return DataTypes.BIGINT();
    }

    protected DataType inferFloat32(Object value, Schema schema) {
        return DataTypes.FLOAT();
    }

    protected DataType inferFloat64(Object value, Schema schema) {
        return DataTypes.DOUBLE();
    }

    protected DataType inferString(Object value, Schema schema) {
        if ("io.debezium.time.ZonedTimestamp".equals(schema.name())) {
            int nano = Optional.ofNullable((String)value).map(s -> ZonedTimestamp.FORMATTER.parse((CharSequence)s, Instant::from)).map(Instant::getNano).orElse(0);
            int precision = nano == 0 ? 0 : (nano % 1000 > 0 ? 9 : (nano % 1000000 > 0 ? 6 : (nano % 1000000000 > 0 ? 3 : 0)));
            return DataTypes.TIMESTAMP_LTZ(precision);
        }
        return DataTypes.STRING();
    }

    protected DataType inferBytes(Object value, Schema schema) {
        if ("org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal".equals(schema.name())) {
            int scale = Optional.ofNullable(schema.parameters().get("scale")).map(Integer::parseInt).orElse(0);
            int precision = Optional.ofNullable(schema.parameters().get(PRECISION_PARAMETER_KEY)).map(Integer::parseInt).orElse(20);
            if (precision > 38) {
                return DataTypes.STRING();
            }
            return DataTypes.DECIMAL(precision, scale);
        }
        return DataTypes.BYTES();
    }

    protected DataType inferStruct(Object value, Schema schema) {
        Struct struct = (Struct)value;
        if ("io.debezium.data.VariableScaleDecimal".equals(schema.name())) {
            if (struct == null) {
                return DataTypes.DECIMAL(10, 0);
            }
            SpecialValueDecimal decimal = VariableScaleDecimal.toLogical(struct);
            BigDecimal bigDecimal = decimal.getDecimalValue().orElse(BigDecimal.ZERO);
            return DataTypes.DECIMAL(bigDecimal.precision(), bigDecimal.scale());
        }
        return DataTypes.ROW((DataField[])schema.fields().stream().map(f -> DataTypes.FIELD(f.name(), this.infer(struct.get(f.name()), f.schema()))).toArray(DataField[]::new));
    }

    protected DataType inferArray(Object value, Schema schema) {
        Schema elementSchema = schema.valueSchema();
        if (elementSchema != null) {
            DataType elementType = this.infer(null, elementSchema);
            return DataTypes.ARRAY(elementType);
        }
        return DataTypes.ARRAY(DataTypes.STRING());
    }

    protected DataType inferMap(Object value, Schema schema) {
        Schema keySchema = schema.keySchema();
        Schema valueSchema = schema.valueSchema();
        DataType keyType = keySchema != null ? this.infer(null, keySchema) : DataTypes.STRING();
        DataType valueType = valueSchema != null ? this.infer(null, valueSchema) : DataTypes.STRING();
        return DataTypes.MAP(keyType, valueType);
    }
}

