/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.data;

import java.time.LocalDate;
import java.util.Objects;

public class DateData
implements Comparable<DateData> {
    private final int epochDay;

    private DateData(int epochDay) {
        this.epochDay = epochDay;
    }

    public static DateData fromEpochDay(int epochOfDay) {
        return new DateData(epochOfDay);
    }

    public static DateData fromLocalDate(LocalDate date) {
        return DateData.fromEpochDay((int)date.toEpochDay());
    }

    public static DateData fromIsoLocalDateString(String dateString) {
        return DateData.fromLocalDate(LocalDate.parse(dateString));
    }

    public int toEpochDay() {
        return this.epochDay;
    }

    public LocalDate toLocalDate() {
        return LocalDate.ofEpochDay(this.epochDay);
    }

    public String toString() {
        return this.toLocalDate().toString();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof DateData)) {
            return false;
        }
        DateData dateData = (DateData)o;
        return this.epochDay == dateData.epochDay;
    }

    @Override
    public int compareTo(DateData other) {
        return Long.compare(this.epochDay, other.epochDay);
    }

    public int hashCode() {
        return Objects.hash(this.epochDay);
    }
}

