/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.LegacyV1AbstractSourceInfoStructMaker;
import io.debezium.connector.sqlserver.SourceInfo;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;

public class LegacyV1SqlServerSourceInfoStructMaker
extends LegacyV1AbstractSourceInfoStructMaker<SourceInfo> {
    public static final String SERVER_NAME_KEY = "name";
    public static final String LOG_TIMESTAMP_KEY = "ts_ms";
    public static final String CHANGE_LSN_KEY = "change_lsn";
    public static final String COMMIT_LSN_KEY = "commit_lsn";
    public static final String SNAPSHOT_KEY = "snapshot";
    private final Schema schema = this.commonSchemaBuilder().name("io.debezium.connector.sqlserver.Source").field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("change_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("snapshot", Schema.OPTIONAL_BOOLEAN_SCHEMA).build();

    public LegacyV1SqlServerSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Struct struct(SourceInfo sourceInfo) {
        Struct ret = super.commonStruct().put(SERVER_NAME_KEY, (Object)this.serverName).put(LOG_TIMESTAMP_KEY, sourceInfo.timestamp() == null ? null : Long.valueOf(sourceInfo.timestamp().toEpochMilli())).put(SNAPSHOT_KEY, (Object)sourceInfo.isSnapshot());
        if (sourceInfo.getChangeLsn() != null && sourceInfo.getChangeLsn().isAvailable()) {
            ret.put(CHANGE_LSN_KEY, (Object)sourceInfo.getChangeLsn().toString());
        }
        if (sourceInfo.getCommitLsn() != null && sourceInfo.getCommitLsn().isAvailable()) {
            ret.put(COMMIT_LSN_KEY, (Object)sourceInfo.getCommitLsn().toString());
        }
        return ret;
    }
}

