/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerErrorHandler;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerTaskContext;
import io.debezium.connector.sqlserver.SqlServerTopicSelector;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetrics;
import io.debezium.pipeline.metrics.StreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Collect;
import io.debezium.util.SchemaNameAdjuster;
import java.time.Instant;
import java.util.Map;
import org.apache.flink.cdc.connectors.base.WatermarkDispatcher;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.relational.JdbcSourceEventDispatcher;
import org.apache.flink.cdc.connectors.base.source.EmbeddedFlinkDatabaseHistory;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.reader.external.JdbcSourceFetchTaskContext;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.cdc.connectors.sqlserver.source.config.SqlServerSourceConfig;
import org.apache.flink.cdc.connectors.sqlserver.source.dialect.SqlServerDialect;
import org.apache.flink.cdc.connectors.sqlserver.source.handler.SqlServerSchemaChangeEventHandler;
import org.apache.flink.cdc.connectors.sqlserver.source.offset.LsnOffset;
import org.apache.flink.cdc.connectors.sqlserver.source.utils.SqlServerUtils;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerSourceFetchTaskContext
extends JdbcSourceFetchTaskContext {
    private static final Logger LOG = LoggerFactory.getLogger(SqlServerSourceFetchTaskContext.class);
    private final SqlServerConnection connection;
    private final SqlServerConnection metaDataConnection;
    private final SqlServerEventMetadataProvider metadataProvider;
    private SqlServerOffsetContext offsetContext;
    private SqlServerPartition partition;
    private SqlServerDatabaseSchema databaseSchema;
    private JdbcSourceEventDispatcher<SqlServerPartition> dispatcher;
    private SqlServerErrorHandler errorHandler;
    private ChangeEventQueue<DataChangeEvent> queue;
    private SqlServerTaskContext taskContext;
    private TopicSelector<TableId> topicSelector;
    private EventDispatcher.SnapshotReceiver<SqlServerPartition> snapshotReceiver;
    private SnapshotChangeEventSourceMetrics<SqlServerPartition> snapshotChangeEventSourceMetrics;
    private StreamingChangeEventSourceMetrics<SqlServerPartition> streamingChangeEventSourceMetrics;

    public SqlServerSourceFetchTaskContext(JdbcSourceConfig sourceConfig, SqlServerDialect dataSourceDialect, SqlServerConnection connection, SqlServerConnection metaDataConnection) {
        super(sourceConfig, dataSourceDialect);
        this.connection = connection;
        this.metadataProvider = new SqlServerEventMetadataProvider();
        this.metaDataConnection = metaDataConnection;
    }

    @Override
    public void configure(SourceSplitBase sourceSplitBase) {
        SqlServerConnectorConfig connectorConfig = this.getDbzConnectorConfig();
        this.topicSelector = SqlServerTopicSelector.defaultSelector(connectorConfig);
        EmbeddedFlinkDatabaseHistory.registerHistory(this.sourceConfig.getDbzConfiguration().getString("database.history.instance.name"), sourceSplitBase.getTableSchemas().values());
        this.databaseSchema = SqlServerUtils.createSqlServerDatabaseSchema(connectorConfig, this.connection);
        this.offsetContext = this.loadStartingOffsetState(new SqlServerOffsetContext.Loader(connectorConfig), sourceSplitBase);
        String serverName = connectorConfig.getLogicalName();
        String dbName = connectorConfig.getJdbcConfig().getDatabase();
        this.partition = new SqlServerPartition(serverName, dbName, false);
        this.validateAndLoadDatabaseHistory(this.offsetContext, this.databaseSchema);
        this.taskContext = new SqlServerTaskContext(connectorConfig, this.databaseSchema);
        int queueSize = this.getSourceConfig().getDbzConnectorConfig().getMaxQueueSize();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(queueSize).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext("sqlserver-cdc-connector-task")).build();
        this.dispatcher = new JdbcSourceEventDispatcher((CommonConnectorConfig)connectorConfig, this.topicSelector, this.databaseSchema, this.queue, connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, (EventMetadataProvider)this.metadataProvider, this.schemaNameAdjuster, new SqlServerSchemaChangeEventHandler());
        this.snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
        DefaultChangeEventSourceMetricsFactory changeEventSourceMetricsFactory = new DefaultChangeEventSourceMetricsFactory();
        this.snapshotChangeEventSourceMetrics = changeEventSourceMetricsFactory.getSnapshotMetrics(this.taskContext, this.queue, this.metadataProvider);
        this.streamingChangeEventSourceMetrics = changeEventSourceMetricsFactory.getStreamingMetrics(this.taskContext, this.queue, this.metadataProvider);
        this.errorHandler = new SqlServerErrorHandler(connectorConfig, this.queue);
    }

    private SqlServerOffsetContext loadStartingOffsetState(SqlServerOffsetContext.Loader loader, SourceSplitBase sourceSplitBase) {
        LsnOffset offset = sourceSplitBase.isSnapshotSplit() ? LsnOffset.INITIAL_OFFSET : sourceSplitBase.asStreamSplit().getStartingOffset();
        return loader.load((Map)offset.getOffset());
    }

    private void validateAndLoadDatabaseHistory(SqlServerOffsetContext offset, SqlServerDatabaseSchema schema) {
        schema.initializeStorage();
        schema.recover(this.partition, offset);
    }

    @Override
    public ChangeEventQueue<DataChangeEvent> getQueue() {
        return this.queue;
    }

    @Override
    public Tables.TableFilter getTableFilter() {
        return this.getDbzConnectorConfig().getTableFilters().dataCollectionFilter();
    }

    @Override
    public Offset getStreamOffset(SourceRecord record) {
        return SqlServerUtils.getLsn(record);
    }

    @Override
    public SqlServerDatabaseSchema getDatabaseSchema() {
        return this.databaseSchema;
    }

    @Override
    public RowType getSplitType(Table table) {
        Column splitColumn = SqlServerUtils.getSplitColumn(table, this.sourceConfig.getChunkKeyColumn());
        return SqlServerUtils.getSplitType(splitColumn);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public SqlServerConnectorConfig getDbzConnectorConfig() {
        return (SqlServerConnectorConfig)super.getDbzConnectorConfig();
    }

    @Override
    public SqlServerSourceConfig getSourceConfig() {
        return (SqlServerSourceConfig)this.sourceConfig;
    }

    @Override
    public JdbcSourceEventDispatcher<SqlServerPartition> getEventDispatcher() {
        return this.dispatcher;
    }

    @Override
    public WatermarkDispatcher getWaterMarkDispatcher() {
        return this.dispatcher;
    }

    public EventDispatcher.SnapshotReceiver<SqlServerPartition> getSnapshotReceiver() {
        return this.snapshotReceiver;
    }

    @Override
    public SqlServerOffsetContext getOffsetContext() {
        return this.offsetContext;
    }

    @Override
    public SqlServerPartition getPartition() {
        return this.partition;
    }

    public SqlServerConnection getConnection() {
        return this.connection;
    }

    public SqlServerConnection getMetaDataConnection() {
        return this.metaDataConnection;
    }

    public SnapshotChangeEventSourceMetrics<SqlServerPartition> getSnapshotChangeEventSourceMetrics() {
        return this.snapshotChangeEventSourceMetrics;
    }

    public StreamingChangeEventSourceMetrics<SqlServerPartition> getStreamingChangeEventSourceMetrics() {
        return this.streamingChangeEventSourceMetrics;
    }

    @Override
    public void close() throws Exception {
        this.metaDataConnection.close();
        this.connection.close();
    }

    @Override
    public SchemaNameAdjuster getSchemaNameAdjuster() {
        return this.schemaNameAdjuster;
    }

    public static class SqlServerEventMetadataProvider
    implements EventMetadataProvider {
        @Override
        public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
            if (value == null) {
                return null;
            }
            Struct sourceInfo = value.getStruct("source");
            if (source == null) {
                return null;
            }
            Long timestamp = sourceInfo.getInt64("ts_ms");
            return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
        }

        @Override
        public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
            if (value == null) {
                return null;
            }
            Struct sourceInfo = value.getStruct("source");
            if (source == null) {
                return null;
            }
            return Collect.hashMapOf("commit_lsn", sourceInfo.getString("commit_lsn"), "change_lsn", sourceInfo.getString("change_lsn"));
        }

        @Override
        public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
            if (value == null) {
                return null;
            }
            Struct sourceInfo = value.getStruct("source");
            if (source == null) {
                return null;
            }
            return sourceInfo.getString("commit_lsn");
        }
    }
}

