/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.json;

import java.util.Collections;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serializer;

public class JsonSerializer
implements Serializer<JsonNode> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonSerializer() {
        this(Collections.emptySet(), JsonNodeFactory.withExactBigDecimals(true));
    }

    JsonSerializer(Set<SerializationFeature> serializationFeatures, JsonNodeFactory jsonNodeFactory) {
        serializationFeatures.forEach(this.objectMapper::enable);
        this.objectMapper.setNodeFactory(jsonNodeFactory);
    }

    @Override
    public byte[] serialize(String topic, JsonNode data) {
        if (data == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing JSON message", e);
        }
    }
}

