/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;

public class DescribeLogDirsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    List<DescribeLogDirsResult> results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public DescribeLogDirsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeLogDirsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.results = new ArrayList<DescribeLogDirsResult>(0);
    }

    @Override
    public short apiKey() {
        return 35;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DescribeLogDirsResult> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _version >= 3 ? _readable.readShort() : (short)0;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeLogDirsResult(_readable, _version));
            }
            this.results = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new ArrayList<DescribeLogDirsResult>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeLogDirsResult(_readable, _version));
            }
            this.results = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 3) {
            _writable.writeShort(this.errorCode);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.results.size() + 1);
            for (DescribeLogDirsResult resultsElement : this.results) {
                resultsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.results.size());
            for (DescribeLogDirsResult resultsElement : this.results) {
                resultsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 3) {
            _size.addBytes(2);
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.results.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (DescribeLogDirsResult resultsElement : this.results) {
            resultsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeLogDirsResponseData)) {
            return false;
        }
        DescribeLogDirsResponseData other = (DescribeLogDirsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    @Override
    public DescribeLogDirsResponseData duplicate() {
        DescribeLogDirsResponseData _duplicate = new DescribeLogDirsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        ArrayList<DescribeLogDirsResult> newResults = new ArrayList<DescribeLogDirsResult>(this.results.size());
        for (DescribeLogDirsResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "DescribeLogDirsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<DescribeLogDirsResult> results() {
        return this.results;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeLogDirsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeLogDirsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeLogDirsResponseData setResults(List<DescribeLogDirsResult> v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(DescribeLogDirsResult.SCHEMA_0), "The log directories."));
        SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new CompactArrayOf(DescribeLogDirsResult.SCHEMA_2), "The log directories."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("results", new CompactArrayOf(DescribeLogDirsResult.SCHEMA_2), "The log directories."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class DescribeLogDirsPartition
    implements Message {
        int partitionIndex;
        long partitionSize;
        long offsetLag;
        boolean isFutureKey;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DescribeLogDirsPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeLogDirsPartition() {
            this.partitionIndex = 0;
            this.partitionSize = 0L;
            this.offsetLag = 0L;
            this.isFutureKey = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.partitionSize = _readable.readLong();
            this.offsetLag = _readable.readLong();
            this.isFutureKey = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.partitionSize);
            _writable.writeLong(this.offsetLag);
            _writable.writeByte(this.isFutureKey ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeLogDirsPartition");
            }
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsPartition)) {
                return false;
            }
            DescribeLogDirsPartition other = (DescribeLogDirsPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.partitionSize != other.partitionSize) {
                return false;
            }
            if (this.offsetLag != other.offsetLag) {
                return false;
            }
            if (this.isFutureKey != other.isFutureKey) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.partitionSize >> 32) ^ (int)this.partitionSize);
            hashCode = 31 * hashCode + ((int)(this.offsetLag >> 32) ^ (int)this.offsetLag);
            hashCode = 31 * hashCode + (this.isFutureKey ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public DescribeLogDirsPartition duplicate() {
            DescribeLogDirsPartition _duplicate = new DescribeLogDirsPartition();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.partitionSize = this.partitionSize;
            _duplicate.offsetLag = this.offsetLag;
            _duplicate.isFutureKey = this.isFutureKey;
            return _duplicate;
        }

        public String toString() {
            return "DescribeLogDirsPartition(partitionIndex=" + this.partitionIndex + ", partitionSize=" + this.partitionSize + ", offsetLag=" + this.offsetLag + ", isFutureKey=" + (this.isFutureKey ? "true" : "false") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long partitionSize() {
            return this.partitionSize;
        }

        public long offsetLag() {
            return this.offsetLag;
        }

        public boolean isFutureKey() {
            return this.isFutureKey;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeLogDirsPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public DescribeLogDirsPartition setPartitionSize(long v) {
            this.partitionSize = v;
            return this;
        }

        public DescribeLogDirsPartition setOffsetLag(long v) {
            this.offsetLag = v;
            return this;
        }

        public DescribeLogDirsPartition setIsFutureKey(boolean v) {
            this.isFutureKey = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("partition_size", Type.INT64, "The size of the log segments in this partition in bytes."), new Field("offset_lag", Type.INT64, "The lag of the log's LEO w.r.t. partition's HW (if it is the current log for the partition) or current replica's LEO (if it is the future log for the partition)"), new Field("is_future_key", Type.BOOLEAN, "True if this log is created by AlterReplicaLogDirsRequest and will replace the current log of the replica in the future."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("partition_size", Type.INT64, "The size of the log segments in this partition in bytes."), new Field("offset_lag", Type.INT64, "The lag of the log's LEO w.r.t. partition's HW (if it is the current log for the partition) or current replica's LEO (if it is the future log for the partition)"), new Field("is_future_key", Type.BOOLEAN, "True if this log is created by AlterReplicaLogDirsRequest and will replace the current log of the replica in the future."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class DescribeLogDirsTopic
    implements Message {
        String name;
        List<DescribeLogDirsPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DescribeLogDirsTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeLogDirsTopic() {
            this.name = "";
            this.partitions = new ArrayList<DescribeLogDirsPartition>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DescribeLogDirsPartition> newCollection;
            int arrayLength;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsTopic");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeLogDirsPartition(_readable, _version));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList<DescribeLogDirsPartition>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeLogDirsPartition(_readable, _version));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeLogDirsPartition partitionsElement = (DescribeLogDirsPartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeLogDirsPartition partitionsElement = (DescribeLogDirsPartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeLogDirsTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (DescribeLogDirsPartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsTopic)) {
                return false;
            }
            DescribeLogDirsTopic other = (DescribeLogDirsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public DescribeLogDirsTopic duplicate() {
            DescribeLogDirsTopic _duplicate = new DescribeLogDirsTopic();
            _duplicate.name = this.name;
            ArrayList<DescribeLogDirsPartition> newPartitions = new ArrayList<DescribeLogDirsPartition>(this.partitions.size());
            for (DescribeLogDirsPartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "DescribeLogDirsTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<DescribeLogDirsPartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeLogDirsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public DescribeLogDirsTopic setPartitions(List<DescribeLogDirsPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(DescribeLogDirsPartition.SCHEMA_0), ""));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(DescribeLogDirsPartition.SCHEMA_2), ""), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class DescribeLogDirsResult
    implements Message {
        short errorCode;
        String logDir;
        List<DescribeLogDirsTopic> topics;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DescribeLogDirsResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeLogDirsResult() {
            this.errorCode = 0;
            this.logDir = "";
            this.topics = new ArrayList<DescribeLogDirsTopic>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DescribeLogDirsTopic> newCollection;
            int arrayLength;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsResult");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field logDir was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field logDir had invalid length " + length);
            }
            this.logDir = _readable.readString(length);
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topics was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeLogDirsTopic(_readable, _version));
                }
                this.topics = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topics was serialized as null");
                }
                newCollection = new ArrayList<DescribeLogDirsTopic>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeLogDirsTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            Object _stringBytes = _cache.getSerializedValue(this.logDir);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeLogDirsTopic topicsElement = (DescribeLogDirsTopic)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.topics.size());
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeLogDirsTopic topicsElement = (DescribeLogDirsTopic)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeLogDirsResult");
            }
            _size.addBytes(2);
            byte[] _stringBytes = this.logDir.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'logDir' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.logDir, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (DescribeLogDirsTopic topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsResult)) {
                return false;
            }
            DescribeLogDirsResult other = (DescribeLogDirsResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.logDir == null ? other.logDir != null : !this.logDir.equals(other.logDir)) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.logDir == null ? 0 : this.logDir.hashCode());
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            return hashCode;
        }

        @Override
        public DescribeLogDirsResult duplicate() {
            DescribeLogDirsResult _duplicate = new DescribeLogDirsResult();
            _duplicate.errorCode = this.errorCode;
            _duplicate.logDir = this.logDir;
            ArrayList<DescribeLogDirsTopic> newTopics = new ArrayList<DescribeLogDirsTopic>(this.topics.size());
            for (DescribeLogDirsTopic _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
            return _duplicate;
        }

        public String toString() {
            return "DescribeLogDirsResult(errorCode=" + this.errorCode + ", logDir=" + (this.logDir == null ? "null" : "'" + this.logDir.toString() + "'") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String logDir() {
            return this.logDir;
        }

        public List<DescribeLogDirsTopic> topics() {
            return this.topics;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeLogDirsResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeLogDirsResult setLogDir(String v) {
            this.logDir = v;
            return this;
        }

        public DescribeLogDirsResult setTopics(List<DescribeLogDirsTopic> v) {
            this.topics = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("log_dir", Type.STRING, "The absolute log directory path."), new Field("topics", new ArrayOf(DescribeLogDirsTopic.SCHEMA_0), "Each topic."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("log_dir", Type.COMPACT_STRING, "The absolute log directory path."), new Field("topics", new CompactArrayOf(DescribeLogDirsTopic.SCHEMA_2), "Each topic."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

