/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.assigner;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.DataSourceDialect;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.base.source.assigner.AssignerStatus;
import org.apache.flink.cdc.connectors.base.source.assigner.SplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.assigner.state.StreamPendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.meta.split.StreamSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSplitAssigner
implements SplitAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(StreamSplitAssigner.class);
    private static final String STREAM_SPLIT_ID = "stream-split";
    private final SourceConfig sourceConfig;
    private boolean isStreamSplitAssigned;
    private final DataSourceDialect dialect;
    private final OffsetFactory offsetFactory;

    public StreamSplitAssigner(SourceConfig sourceConfig, DataSourceDialect dialect, OffsetFactory offsetFactory) {
        this(sourceConfig, false, dialect, offsetFactory);
    }

    public StreamSplitAssigner(SourceConfig sourceConfig, StreamPendingSplitsState checkpoint, DataSourceDialect dialect, OffsetFactory offsetFactory) {
        this(sourceConfig, checkpoint.isStreamSplitAssigned(), dialect, offsetFactory);
    }

    private StreamSplitAssigner(SourceConfig sourceConfig, boolean isStreamSplitAssigned, DataSourceDialect dialect, OffsetFactory offsetFactory) {
        this.sourceConfig = sourceConfig;
        this.isStreamSplitAssigned = isStreamSplitAssigned;
        this.dialect = dialect;
        this.offsetFactory = offsetFactory;
    }

    @Override
    public void open() {
    }

    @Override
    public Optional<SourceSplitBase> getNext() {
        if (this.isStreamSplitAssigned) {
            return Optional.empty();
        }
        this.isStreamSplitAssigned = true;
        return Optional.of(this.createStreamSplit());
    }

    @Override
    public boolean waitingForFinishedSplits() {
        return false;
    }

    @Override
    public List<FinishedSnapshotSplitInfo> getFinishedSplitInfos() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void onFinishedSplits(Map<String, Offset> splitFinishedOffsets) {
    }

    @Override
    public void addSplits(Collection<SourceSplitBase> splits) {
        this.isStreamSplitAssigned = false;
    }

    @Override
    public PendingSplitsState snapshotState(long checkpointId) {
        return new StreamPendingSplitsState(this.isStreamSplitAssigned);
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
    }

    @Override
    public AssignerStatus getAssignerStatus() {
        return AssignerStatus.INITIAL_ASSIGNING_FINISHED;
    }

    @Override
    public void startAssignNewlyAddedTables() {
    }

    @Override
    public void onStreamSplitUpdated() {
    }

    @Override
    public boolean noMoreSplits() {
        return this.isStreamSplitAssigned;
    }

    @Override
    public void close() {
    }

    public StreamSplit createStreamSplit() {
        Offset startingOffset;
        StartupOptions startupOptions = this.sourceConfig.getStartupOptions();
        switch (startupOptions.startupMode) {
            case LATEST_OFFSET: {
                startingOffset = this.dialect.displayCurrentOffset(this.sourceConfig);
                break;
            }
            case EARLIEST_OFFSET: {
                startingOffset = this.offsetFactory.createInitialOffset();
                break;
            }
            case TIMESTAMP: {
                startingOffset = this.offsetFactory.createTimestampOffset(startupOptions.startupTimestampMillis);
                break;
            }
            case SPECIFIC_OFFSETS: {
                startingOffset = this.offsetFactory.newOffset(startupOptions.specificOffsetFile, startupOptions.specificOffsetPos.longValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported startup mode " + (Object)((Object)startupOptions.startupMode));
            }
        }
        return new StreamSplit(STREAM_SPLIT_ID, startingOffset, this.offsetFactory.createNoStoppingOffset(), new ArrayList<FinishedSnapshotSplitInfo>(), new HashMap<TableId, TableChanges.TableChange>(), 0);
    }
}

