/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.metrics;

import io.debezium.relational.TableId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.cdc.connectors.base.source.meta.split.SnapshotSplit;
import org.apache.flink.cdc.connectors.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.SplitEnumeratorMetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceEnumeratorMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceEnumeratorMetrics.class);
    public static final int UNDEFINED = 0;
    public static final String IS_SNAPSHOTTING = "isSnapshotting";
    public static final String IS_STREAM_READING = "isStreamReading";
    public static final String NUM_TABLES_SNAPSHOTTED = "numTablesSnapshotted";
    public static final String NUM_TABLES_REMAINING = "numTablesRemaining";
    public static final String NUM_SNAPSHOT_SPLITS_PROCESSED = "numSnapshotSplitsProcessed";
    public static final String NUM_SNAPSHOT_SPLITS_REMAINING = "numSnapshotSplitsRemaining";
    public static final String NUM_SNAPSHOT_SPLITS_FINISHED = "numSnapshotSplitsFinished";
    public static final String SNAPSHOT_START_TIME = "snapshotStartTime";
    public static final String SNAPSHOT_END_TIME = "snapshotEndTime";
    public static final String NAMESPACE_GROUP_KEY = "namespace";
    public static final String SCHEMA_GROUP_KEY = "schema";
    public static final String TABLE_GROUP_KEY = "table";
    private final SplitEnumeratorMetricGroup metricGroup;
    private volatile int isSnapshotting = 0;
    private volatile int isStreamReading = 0;
    private volatile int numTablesRemaining = 0;
    private final Map<TableId, TableMetrics> tableMetricsMap = new ConcurrentHashMap<TableId, TableMetrics>();

    public SourceEnumeratorMetrics(SplitEnumeratorMetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        metricGroup.gauge(IS_SNAPSHOTTING, () -> this.isSnapshotting);
        metricGroup.gauge(IS_STREAM_READING, () -> this.isStreamReading);
        metricGroup.gauge(NUM_TABLES_REMAINING, () -> this.numTablesRemaining);
    }

    public void enterSnapshotPhase() {
        this.isSnapshotting = 1;
    }

    public void exitSnapshotPhase() {
        this.isSnapshotting = 0;
    }

    public void enterStreamReading() {
        this.isStreamReading = 1;
    }

    public void exitStreamReading() {
        this.isStreamReading = 0;
    }

    public void registerMetrics(Gauge<Integer> numTablesSnapshotted, Gauge<Integer> numSnapshotSplitsProcessed, Gauge<Integer> numSnapshotSplitsRemaining) {
        this.metricGroup.gauge(NUM_TABLES_SNAPSHOTTED, numTablesSnapshotted);
        this.metricGroup.gauge(NUM_SNAPSHOT_SPLITS_PROCESSED, numSnapshotSplitsProcessed);
        this.metricGroup.gauge(NUM_SNAPSHOT_SPLITS_REMAINING, numSnapshotSplitsRemaining);
    }

    public void addNewTables(int numNewTables) {
        this.numTablesRemaining += numNewTables;
    }

    public void startSnapshotTables(int numSnapshottedTables) {
        this.numTablesRemaining -= numSnapshottedTables;
    }

    public TableMetrics getTableMetrics(TableId tableId) {
        return this.tableMetricsMap.computeIfAbsent(tableId, key -> new TableMetrics(key.catalog(), key.schema(), key.table(), (MetricGroup)this.metricGroup));
    }

    public static class TableMetrics {
        private AtomicInteger numSnapshotSplitsProcessed = new AtomicInteger(0);
        private AtomicInteger numSnapshotSplitsRemaining = new AtomicInteger(0);
        private AtomicInteger numSnapshotSplitsFinished = new AtomicInteger(0);
        private volatile long snapshotStartTime = 0L;
        private volatile long snapshotEndTime = 0L;
        private Set<Integer> remainingSplitChunkIds = Collections.newSetFromMap(new ConcurrentHashMap());
        private Set<Integer> processedSplitChunkIds = Collections.newSetFromMap(new ConcurrentHashMap());
        private Set<Integer> finishedSplitChunkIds = Collections.newSetFromMap(new ConcurrentHashMap());

        public TableMetrics(String databaseName, String schemaName, String tableName, MetricGroup parentGroup) {
            databaseName = this.processNull(databaseName);
            schemaName = this.processNull(schemaName);
            tableName = this.processNull(tableName);
            MetricGroup metricGroup = parentGroup.addGroup(SourceEnumeratorMetrics.NAMESPACE_GROUP_KEY, databaseName).addGroup(SourceEnumeratorMetrics.SCHEMA_GROUP_KEY, schemaName).addGroup(SourceEnumeratorMetrics.TABLE_GROUP_KEY, tableName);
            metricGroup.gauge(SourceEnumeratorMetrics.NUM_SNAPSHOT_SPLITS_PROCESSED, () -> this.numSnapshotSplitsProcessed.intValue());
            metricGroup.gauge(SourceEnumeratorMetrics.NUM_SNAPSHOT_SPLITS_REMAINING, () -> this.numSnapshotSplitsRemaining.intValue());
            metricGroup.gauge(SourceEnumeratorMetrics.NUM_SNAPSHOT_SPLITS_FINISHED, () -> this.numSnapshotSplitsFinished.intValue());
            metricGroup.gauge(SourceEnumeratorMetrics.SNAPSHOT_START_TIME, () -> this.snapshotStartTime);
            metricGroup.gauge(SourceEnumeratorMetrics.SNAPSHOT_END_TIME, () -> this.snapshotEndTime);
            this.snapshotStartTime = System.currentTimeMillis();
        }

        private String processNull(String name) {
            if (StringUtils.isBlank(name)) {
                return "";
            }
            return name;
        }

        public void addNewSplit(String newSplitId) {
            int chunkId = SnapshotSplit.extractChunkId(newSplitId);
            if (!this.remainingSplitChunkIds.contains(chunkId)) {
                this.remainingSplitChunkIds.add(chunkId);
                this.numSnapshotSplitsRemaining.getAndAdd(1);
                LOGGER.info("add remaining split: {}", (Object)newSplitId);
            }
        }

        public void addNewSplits(List<String> newSplitIds) {
            if (newSplitIds != null) {
                for (String newSplitId : newSplitIds) {
                    this.addNewSplit(newSplitId);
                }
            }
        }

        public void removeRemainingSplit(String removeSplitId) {
            int chunkId = SnapshotSplit.extractChunkId(removeSplitId);
            if (this.remainingSplitChunkIds.contains(chunkId)) {
                this.remainingSplitChunkIds.remove(chunkId);
                this.numSnapshotSplitsRemaining.getAndUpdate(num -> num - 1);
                LOGGER.info("remove remaining split: {}", (Object)removeSplitId);
            }
        }

        public void addProcessedSplit(String processedSplitId) {
            int chunkId = SnapshotSplit.extractChunkId(processedSplitId);
            if (!this.processedSplitChunkIds.contains(chunkId)) {
                this.processedSplitChunkIds.add(chunkId);
                this.numSnapshotSplitsProcessed.getAndAdd(1);
                LOGGER.info("add processed split: {}", (Object)processedSplitId);
            }
        }

        public void removeProcessedSplit(String removeSplitId) {
            int chunkId = SnapshotSplit.extractChunkId(removeSplitId);
            if (this.processedSplitChunkIds.contains(chunkId)) {
                this.processedSplitChunkIds.remove(chunkId);
                this.numSnapshotSplitsProcessed.getAndUpdate(num -> num - 1);
                LOGGER.info("remove processed split: {}", (Object)removeSplitId);
            }
        }

        public void reprocessSplit(String reprocessSplitId) {
            this.addNewSplit(reprocessSplitId);
            this.removeProcessedSplit(reprocessSplitId);
        }

        public void finishProcessSplit(String processedSplitId) {
            this.addProcessedSplit(processedSplitId);
            this.removeRemainingSplit(processedSplitId);
        }

        public void tryToMarkSnapshotEndTime() {
            if (this.numSnapshotSplitsRemaining.get() == 0 && this.numSnapshotSplitsFinished.get() == this.numSnapshotSplitsProcessed.get()) {
                this.snapshotEndTime = System.currentTimeMillis();
            }
        }

        public void addFinishedSplits(Set<String> finishedSplitIds) {
            if (finishedSplitIds != null) {
                for (String finishedSplitId : finishedSplitIds) {
                    this.addFinishedSplit(finishedSplitId);
                }
            }
        }

        public void addFinishedSplit(String finishedSplitId) {
            int chunkId = SnapshotSplit.extractChunkId(finishedSplitId);
            if (!this.finishedSplitChunkIds.contains(chunkId)) {
                this.finishedSplitChunkIds.add(chunkId);
                this.numSnapshotSplitsFinished.getAndAdd(1);
                this.tryToMarkSnapshotEndTime();
                LOGGER.info("add finished split: {}", (Object)finishedSplitId);
            }
        }

        public void removeFinishedSplit(String removeSplitId) {
            int chunkId = SnapshotSplit.extractChunkId(removeSplitId);
            if (this.finishedSplitChunkIds.contains(chunkId)) {
                this.finishedSplitChunkIds.remove(chunkId);
                this.numSnapshotSplitsFinished.getAndUpdate(num -> num - 1);
                LOGGER.info("remove finished split: {}", (Object)removeSplitId);
            }
        }
    }
}

