/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.common.util;

import java.lang.reflect.Field;
import org.apache.flink.cdc.connectors.shaded.org.apache.commons.lang3.StringUtils;

public class TypeTrait {
    public static boolean isNumber(Object obj) {
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long;
    }

    public static boolean isNumber(Field field) {
        String typeName = field.getGenericType().getTypeName();
        return "byte".equals(typeName) || "java.lang.Byte".equals(typeName) || "short".equals(typeName) || "java.lang.Short".equals(typeName) || "int".equals(typeName) || "java.lang.Integer".equals(typeName) || "long".equals(typeName) || "java.lang.Long".equals(typeName);
    }

    public static boolean isReal(Object obj) {
        return obj instanceof Float || obj instanceof Double;
    }

    public static boolean isReal(Field field) {
        String typeName = field.getGenericType().getTypeName();
        return "float".equals(typeName) || "java.lang.Float".equals(typeName) || "double".equals(typeName) || "java.lang.Double".equals(typeName);
    }

    public static boolean isBool(Object obj) {
        return obj instanceof Boolean;
    }

    public static boolean isBool(Field field) {
        String typeName = field.getGenericType().getTypeName();
        return "boolean".equals(typeName) || "java.lang.Boolean".equals(typeName);
    }

    public static boolean isString(Object obj) {
        return obj instanceof Character || obj instanceof String;
    }

    public static boolean isString(Field field) {
        String typeName = field.getGenericType().getTypeName();
        return "char".equals(typeName) || "java.lang.Character".equals(typeName) || "java.lang.String".equals(typeName);
    }

    public static boolean isSameLooseType(Object object, Field field) {
        return TypeTrait.isNumber(object) && TypeTrait.isNumber(field) || TypeTrait.isReal(object) && TypeTrait.isReal(field) || TypeTrait.isBool(object) && TypeTrait.isBool(field) || TypeTrait.isString(object) && TypeTrait.isString(field);
    }

    public static <T> T fromString(String value, Class<?> clazz) {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(!StringUtils.isEmpty(value) && Boolean.parseBoolean(value));
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            if (StringUtils.isNotEmpty(value)) {
                return (T)Character.valueOf(value.charAt(0));
            }
        } else if (clazz == String.class) {
            return (T)value;
        }
        return null;
    }
}

